/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent.transport.impl;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import net.sf.infrared.base.model.ApplicationStatistics;
import net.sf.infrared.base.model.OperationStatistics;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class SocketWriter {
    private static final Logger log = LoggingFactory.getLogger(SocketWriter.class);
    private static final int DEFAULT_PORT = 7777;
    private static final int DEFAULT_RECONNECTION_DELAY = 30000;
    private static final int RESET_FREQUENCY = 1;
    private ObjectOutputStream oos;
    private int reconnectionDelay = 30000;
    private boolean closed = false;
    private InetAddress address;
    private int port = 7777;
    private int counter = 0;
    private Connector connector;

    public SocketWriter() {
    }

    public SocketWriter(InetAddress address, int port) {
        this.address = address;
        this.port = port;
        this.connect(address, port);
    }

    public SocketWriter(String host, int port) {
        this.port = port;
        this.address = SocketWriter.getAddressByName(host);
        this.connect(this.address, port);
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.oos != null) {
            try {
                this.oos.close();
            }
            catch (IOException e) {
                log.error("CleanUp error: Could not close ObjectOutputStream", e);
            }
        }
    }

    void connect(InetAddress address, int port) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.oos = new ObjectOutputStream(new Socket(address, port).getOutputStream());
            if (log.isDebugEnabled()) {
                log.debug("SocketWriter - Connected to " + address + " on port " + port);
            }
        }
        catch (IOException ex) {
            log.error("SocketWriter - Failed to connect to " + address + " on port " + port, ex);
            this.checkAndFireConnector();
        }
    }

    public void write(OperationStatistics stats) {
        this.writeToStream(stats);
    }

    public void write(ApplicationStatistics stats) {
        this.writeToStream(stats);
    }

    public void writeToStream(Serializable stats) {
        if (stats == null) {
            return;
        }
        if (this.oos != null) {
            try {
                this.oos.writeObject(stats);
                if (log.isDebugEnabled()) {
                    log.debug(this + " - Wrote stats");
                }
                this.oos.flush();
                if (++this.counter >= 1) {
                    this.counter = 0;
                    log.debug(this + " - Doing oos.reset()");
                    this.oos.reset();
                }
            }
            catch (Throwable th) {
                this.oos = null;
                log.warn("Detected problem with connection", th);
                this.checkAndFireConnector();
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void checkAndFireConnector() {
        if (this.reconnectionDelay > 0 && this.connector == null) {
            this.connector = new Connector();
            this.connector.setDaemon(true);
            this.connector.setPriority(1);
            this.connector.start();
            log.warn("Started connector thread");
        }
    }

    private static InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception ex) {
            log.error("SocketWriter - failed to get InetAddress of host " + host, ex);
            return null;
        }
    }

    public void setReconnectionDelay(int delay) {
        this.reconnectionDelay = delay;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public boolean isConnected() {
        return this.connector == null || !this.connector.isAlive();
    }

    public String toString() {
        return "SocketWriter (address = " + this.address + ", port = " + this.port + (this.isConnected() ? "" : "not ") + " connected)";
    }

    class Connector
    extends Thread {
        private static final int MAX_TRIES_TO_LOG = 5;
        private boolean interrupted = false;
        private int tries = 0;

        Connector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interrupted) {
                try {
                    Connector.sleep(SocketWriter.this.reconnectionDelay);
                    ++this.tries;
                    Socket socket = new Socket(SocketWriter.this.address, SocketWriter.this.port);
                    Connector connector = this;
                    synchronized (connector) {
                        SocketWriter.this.oos = new ObjectOutputStream(socket.getOutputStream());
                        log.debug("Created socket connection with collector after " + this.tries + " attempts");
                        SocketWriter.this.connector = null;
                        this.tries = 0;
                        break;
                    }
                }
                catch (InterruptedException e) {
                    this.logError("Connector thread interrupted", e);
                    return;
                }
                catch (ConnectException e) {
                    this.logError("Remote host '" + SocketWriter.this.address.getHostName() + "' refused connection.", e);
                }
                catch (Throwable th) {
                    this.logError("Could not connect to '" + SocketWriter.this.address.getHostName() + "'", th);
                }
            }
        }

        public void logError(String message, Throwable th) {
            if (this.tries <= 5) {
                log.error(message, th);
            }
            if (this.tries == 5) {
                log.error("Connector tried 5 times to connect to collector but failed. Connector will keep trying, but meanwhile it will not log the errors. It can be assumed that the errors are the same as earlier");
            }
        }
    }
}

