/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.agent.util;

import java.io.InputStream;
import java.net.InetAddress;
import java.util.Properties;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class AgentHelper {
    public static final String VERSION_FILE = "version.txt";
    private static Logger log = LoggingFactory.getLogger(AgentHelper.class);
    private static String hostName;
    private static String version;

    public static String getLocalHostName() {
        if (hostName != null) {
            return hostName;
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable th) {
            log.error("Failed to figure out host name, using default " + hostName, th);
            th.printStackTrace();
            hostName = "unknwon-host";
        }
        return hostName;
    }

    public static String getVersion() {
        if (version != null) {
            return version;
        }
        try {
            InputStream versionUrl = Thread.currentThread().getContextClassLoader().getResourceAsStream(VERSION_FILE);
            Properties props = new Properties();
            if (versionUrl != null) {
                props.load(versionUrl);
                version = props.getProperty("infrared-version");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (version == null || version.trim().equals("")) {
            version = "unknwon";
        }
        return version;
    }
}

