/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.aspects.api;

import java.util.StringTokenizer;
import net.sf.infrared.aspects.AbstractExecutionContext;

public class ApiContext
extends AbstractExecutionContext {
    public static final String DELIMITER = ":";
    private String methodName;
    private String className;

    public ApiContext(String className, String methodName, String layer) {
        super(layer);
        this.className = className;
        this.methodName = methodName;
    }

    public ApiContext(String name, String layer) {
        super(layer);
        if (name == null) {
            throw new IllegalArgumentException("The name argument for the ApiContext constructor cannot be null");
        }
        StringTokenizer st = new StringTokenizer(name, DELIMITER);
        if (st.countTokens() != 2) {
            throw new IllegalArgumentException("The name argument for the ApiContext constructor is invalid");
        }
        this.className = st.nextToken();
        this.methodName = st.nextToken();
    }

    public String getName() {
        return this.className + DELIMITER + this.methodName;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiContext)) {
            return false;
        }
        ApiContext other = (ApiContext)o;
        return this.methodName.equals(other.methodName) && this.getLayer().equals(other.getLayer()) && this.className.equals(other.className);
    }

    public int hashCode() {
        return 7 * this.methodName.hashCode() + 11 * this.className.hashCode() + 13 * this.getLayer().hashCode();
    }

    public String toString() {
        return this.className + DELIMITER + this.methodName + " [" + this.getLayer() + "] ";
    }
}

