/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.aspects.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6Connection;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6Factory;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;
import org.codehaus.aspectwerkz.AspectContext;
import org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint;

public class JdbcAspect {
    private InfraREDP6Factory factory;
    private Logger log = LoggingFactory.getLogger(JdbcAspect.class);

    public JdbcAspect(AspectContext actx) {
        this.factory = new InfraREDP6Factory();
    }

    public Object aroundGetConnection(StaticJoinPoint jp) throws Throwable {
        Connection con = (Connection)jp.proceed();
        if (!(con instanceof InfraREDP6Connection)) {
            try {
                con = this.factory.getConnection(con);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Wrapped Connection with the Infrared P6 connection " + con);
                }
            }
            catch (SQLException sqlex) {
                this.log.error("Failed to wrap Connection with the Infrared P6 connection", sqlex);
            }
        }
        return con;
    }
}

