/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.aspects.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.agent.MonitorFacade;
import net.sf.infrared.agent.MonitorFactory;
import net.sf.infrared.agent.StatisticsCollector;
import net.sf.infrared.aspects.AbstractBaseAspect;
import net.sf.infrared.aspects.api.ApiContext;
import net.sf.infrared.aspects.jdbc.SqlContextManager;
import net.sf.infrared.aspects.jdbc.SqlExecuteContext;
import net.sf.infrared.aspects.jdbc.SqlMemory;
import net.sf.infrared.aspects.jdbc.SqlPrepareContext;
import net.sf.infrared.base.model.ExecutionTimer;
import org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint;

public class NonWrappingJdbcAspect
extends AbstractBaseAspect {
    private static SqlContextManager ctxMgr = new SqlContextManager();
    private static SqlMemory sqlMem = new SqlMemory();

    public Object aroundSimpleSqlExecution(StaticJoinPoint sjp, String sql) throws Throwable {
        MonitorFacade facade = MonitorFactory.getFacade();
        if (!this.isJDBCMonitoringEnabled(facade)) {
            return sjp.proceed();
        }
        SqlExecuteContext ctx = ctxMgr.getExecuteContext(sql);
        return this.recordExecution(ctx, sjp, facade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aroundFirstStatementOrCallPreparation(StaticJoinPoint sjp, String sql) throws Throwable {
        MonitorFacade facade = MonitorFactory.getFacade();
        if (!this.isJDBCMonitoringEnabled(facade)) {
            Object ps = sjp.proceed();
            sqlMem.memorizeSql(sql, ps);
            return ps;
        }
        SqlPrepareContext ctx = ctxMgr.getPrepareContext(sql);
        ExecutionTimer timer = new ExecutionTimer(ctx);
        StatisticsCollector collector = facade.recordExecutionBegin(timer);
        Object ps = null;
        try {
            Object object = ps = sjp.proceed();
            Object var10_10 = null;
            facade.recordExecutionEnd(timer, collector);
            if (ps != null) {
                sqlMem.memorizeSql(sql, ps);
            }
            return object;
        }
        catch (Throwable throwable) {
            block4: {
                Object var10_11 = null;
                facade.recordExecutionEnd(timer, collector);
                if (ps == null) break block4;
                sqlMem.memorizeSql(sql, ps);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object aroundStatementOrCallExecution(StaticJoinPoint sjp, PreparedStatement ps) throws Throwable {
        MonitorFacade facade = MonitorFactory.getFacade();
        if (!this.isJDBCMonitoringEnabled(facade)) {
            return sjp.proceed();
        }
        String sql = sqlMem.recollectSql(ps);
        if (sql == null) {
            return sjp.proceed();
        }
        SqlExecuteContext ctx = ctxMgr.getExecuteContext(sql);
        ExecutionTimer timer = new ExecutionTimer(ctx);
        StatisticsCollector collector = facade.recordExecutionBegin(timer);
        try {
            Object object = sjp.proceed();
            return object;
        }
        finally {
            facade.recordExecutionEnd(timer, collector);
        }
    }

    public Object aroundCommit(StaticJoinPoint sjp) throws Throwable {
        MonitorFacade facade = MonitorFactory.getFacade();
        if (!this.isJDBCMonitoringEnabled(facade)) {
            return sjp.proceed();
        }
        ApiContext ctx = new ApiContext(Connection.class.getName(), "commit", "JDBC");
        return this.recordExecution(ctx, sjp, facade);
    }

    public Object aroundRollback(StaticJoinPoint sjp) throws Throwable {
        MonitorFacade facade = MonitorFactory.getFacade();
        if (!this.isJDBCMonitoringEnabled(facade)) {
            return sjp.proceed();
        }
        ApiContext ctx = new ApiContext(Connection.class.getName(), "rollback", "JDBC");
        return this.recordExecution(ctx, sjp, facade);
    }

    public Object aroundIterateOverResultSet(StaticJoinPoint sjp) throws Throwable {
        MonitorFacade facade = MonitorFactory.getFacade();
        if (!this.isJDBCMonitoringEnabled(facade)) {
            return sjp.proceed();
        }
        ApiContext apiCtx = new ApiContext(ResultSet.class.getName(), "next", "JDBC");
        return this.recordExecution(apiCtx, sjp, facade);
    }

    boolean isJDBCMonitoringEnabled(MonitorFacade facade) {
        MonitorConfig cfg = facade.getConfiguration();
        return cfg.isMonitoringEnabled() && cfg.getProperty("jdbc-monitoring-enable", true);
    }
}

