/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.aspects.jdbc;

import java.util.ArrayList;
import java.util.List;
import net.sf.infrared.aspects.jdbc.SqlExecuteContext;
import net.sf.infrared.aspects.jdbc.SqlPrepareContext;
import net.sf.infrared.base.model.ExecutionContext;

public class SqlContext
implements ExecutionContext {
    private SqlPrepareContext prepare = null;
    private SqlExecuteContext execute = null;
    private String sql;
    private List children = new ArrayList(3);

    public SqlContext(String sql) {
        if (sql == null) {
            throw new IllegalArgumentException("sql string cannot be null");
        }
        this.sql = sql;
    }

    public SqlContext(String sql, String layer) {
        this(sql);
    }

    public String getName() {
        return this.sql;
    }

    public ExecutionContext getParent() {
        return null;
    }

    public String getLayer() {
        return "SQL";
    }

    public List getChildren() {
        return this.children;
    }

    public void addChild(ExecutionContext ctx) {
        if (this.children.contains(ctx)) {
            return;
        }
        if (ctx instanceof SqlPrepareContext) {
            this.prepare = (SqlPrepareContext)ctx;
        } else if (ctx instanceof SqlExecuteContext) {
            this.execute = (SqlExecuteContext)ctx;
        } else {
            throw new IllegalArgumentException("invalid child element for SqlContext");
        }
        this.children.add(ctx);
    }

    public String toString() {
        return this.sql;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlContext)) {
            return false;
        }
        SqlContext other = (SqlContext)o;
        return this.sql.equals(other.sql);
    }

    public int hashCode() {
        return 13 * this.sql.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlPrepareContext getPrepareContext() {
        SqlContext sqlContext = this;
        synchronized (sqlContext) {
            if (this.prepare == null) {
                this.prepare = new SqlPrepareContext(this);
                this.children.add(this.prepare);
            }
        }
        return this.prepare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlExecuteContext getExecuteContext() {
        SqlContext sqlContext = this;
        synchronized (sqlContext) {
            if (this.execute == null) {
                this.execute = new SqlExecuteContext(this);
                this.children.add(this.execute);
            }
        }
        return this.execute;
    }

    public String getSql() {
        return this.sql;
    }
}

