/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.aspects.jdbc.p6spy;

import com.p6spy.engine.spy.P6Connection;
import com.p6spy.engine.spy.P6CoreFactory;
import com.p6spy.engine.spy.P6Statement;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import net.sf.infrared.agent.MonitorConfig;
import net.sf.infrared.agent.MonitorFactory;
import net.sf.infrared.aspects.jdbc.SqlContext;
import net.sf.infrared.aspects.jdbc.SqlContextManager;
import net.sf.infrared.aspects.jdbc.SqlExecuteContext;
import net.sf.infrared.aspects.jdbc.SqlPrepareContext;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6CallableStatement;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6Connection;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6DatabaseMetaData;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6PreparedStatement;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6PreparedStatementWithVariables;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6ResultSet;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6Statement;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class InfraREDP6Factory
extends P6CoreFactory {
    private static final Logger log = LoggingFactory.getLogger(InfraREDP6Factory.class);
    public static final String KEY_JDBC_MONITORING_ENABLED = "jdbc-monitoring-enable";
    public static final String KEY_JDBC_FETCH_STATISTICS_ENABLE = "jdbc-fetch-statistics";
    public static final String KEY_PREPARED_STATEMENT_MONITORING_ENABLED = "prepared-statement-monitoring-enable";
    private SqlContextManager ctxMgr = new SqlContextManager();

    public Connection getConnection(Connection conn) throws SQLException {
        log.debug("InfraRED returning the wrapped InfraREDP6Connection");
        return new InfraREDP6Connection(this, conn);
    }

    public PreparedStatement getPreparedStatement(PreparedStatement real, P6Connection conn, String sql) throws SQLException {
        if (this.isJDBCMonitoringEnabled()) {
            if (this.isPreparedStatementMonitoringEnabled()) {
                return new InfraREDP6PreparedStatementWithVariables(this, real, conn, sql);
            }
            return new InfraREDP6PreparedStatement(this, real, conn, sql);
        }
        return real;
    }

    public Statement getStatement(Statement statement, P6Connection conn) throws SQLException {
        if (this.isJDBCMonitoringEnabled()) {
            return new InfraREDP6Statement(this, statement, conn);
        }
        return statement;
    }

    public ResultSet getResultSet(ResultSet real, P6Statement statement, String preparedQuery, String query) throws SQLException {
        if (this.isJDBCMonitoringEnabled() && this.isCollectFetchDataEnabled()) {
            return real == null ? null : new InfraREDP6ResultSet(this, real, statement, preparedQuery, query);
        }
        return real;
    }

    public Array getArray(Array real, P6Statement statement, String preparedQuery, String query) throws SQLException {
        return real;
    }

    public ResultSetMetaData getResultSetMetaData(ResultSetMetaData real) throws SQLException {
        return real;
    }

    public CallableStatement getCallableStatement(CallableStatement real, P6Connection conn, String p0) throws SQLException {
        if (this.isJDBCMonitoringEnabled()) {
            return new InfraREDP6CallableStatement(this, real, conn, p0);
        }
        return real;
    }

    public DatabaseMetaData getDatabaseMetaData(DatabaseMetaData real, P6Connection conn) throws SQLException {
        return new InfraREDP6DatabaseMetaData(this, real, conn);
    }

    public SqlContext getSqlContext(String sql) {
        return this.ctxMgr.getSqlContext(sql);
    }

    public SqlExecuteContext getExecuteContext(String sql) {
        return this.ctxMgr.getExecuteContext(sql);
    }

    public SqlPrepareContext getPrepareContext(String sql) {
        return this.ctxMgr.getPrepareContext(sql);
    }

    boolean isJDBCMonitoringEnabled() {
        MonitorConfig cfg = MonitorFactory.getFacade().getConfiguration();
        return cfg.isMonitoringEnabled() && cfg.getProperty(KEY_JDBC_MONITORING_ENABLED, true);
    }

    boolean isCollectFetchDataEnabled() {
        MonitorConfig cfg = MonitorFactory.getFacade().getConfiguration();
        return cfg.isMonitoringEnabled() && cfg.getProperty(KEY_JDBC_FETCH_STATISTICS_ENABLE, true);
    }

    boolean isPreparedStatementMonitoringEnabled() {
        MonitorConfig cfg = MonitorFactory.getFacade().getConfiguration();
        return cfg.isMonitoringEnabled() && cfg.getProperty(KEY_PREPARED_STATEMENT_MONITORING_ENABLED, false);
    }

    static {
        log.debug("InfraREDP6Factory class is being used to wrap the database connection");
    }
}

