/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.aspects.jdbc.p6spy;

import com.p6spy.engine.spy.P6Connection;
import com.p6spy.engine.spy.P6PreparedStatement;
import com.p6spy.engine.spy.P6Statement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import net.sf.infrared.agent.MonitorFactory;
import net.sf.infrared.agent.StatisticsCollector;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6Factory;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6Statement;
import net.sf.infrared.base.model.ExecutionContext;
import net.sf.infrared.base.model.ExecutionTimer;

public class InfraREDP6PreparedStatement
extends InfraREDP6Statement
implements PreparedStatement {
    private PreparedStatement passThru;
    private String preparedQuery;
    private ExecutionContext executeCtx;

    public InfraREDP6PreparedStatement(InfraREDP6Factory infraP6Factory, PreparedStatement real, P6Connection conn, String sql) {
        super(infraP6Factory, real, conn);
        this.passThru = real;
        this.factory = infraP6Factory;
        this.preparedQuery = sql;
        this.conn = conn;
        this.executeCtx = infraP6Factory.getExecuteContext(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        if (this.factory.isJDBCMonitoringEnabled()) {
            ExecutionTimer timer = new ExecutionTimer(this.executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                boolean bl = this.passThru.execute();
                return bl;
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        }
        return this.passThru.execute();
    }

    public void addBatch() throws SQLException {
        this.passThru.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.passThru.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.passThru.setRef(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.passThru.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.passThru.setClob(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this.passThru.setArray(i, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.factory.getResultSetMetaData(this.passThru.getMetaData());
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.passThru.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.passThru.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.passThru.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.passThru.setNull(paramIndex, sqlType, typeName);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.passThru.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.passThru.getParameterMetaData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = null;
        if (this.factory.isJDBCMonitoringEnabled()) {
            ExecutionTimer timer = new ExecutionTimer(this.executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                resultSet = this.passThru.executeQuery();
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        } else {
            resultSet = this.passThru.executeQuery();
        }
        return this.factory.getResultSet(resultSet, this.getP6Statement(), this.preparedQuery, this.query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        int returnValue;
        if (this.factory.isJDBCMonitoringEnabled()) {
            ExecutionTimer timer = new ExecutionTimer(this.executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                returnValue = this.passThru.executeUpdate();
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        } else {
            returnValue = this.passThru.executeUpdate();
        }
        return returnValue;
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.passThru.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.passThru.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.passThru.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.passThru.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.passThru.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.passThru.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.passThru.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.passThru.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.passThru.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.passThru.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.passThru.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.passThru.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.passThru.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.passThru.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.passThru.setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.passThru.setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.passThru.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        this.passThru.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.passThru.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.passThru.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.passThru.setObject(parameterIndex, x);
    }

    protected P6Statement getP6Statement() {
        if (this.p6Statement == null) {
            this.p6Statement = new P6PreparedStatement(this.factory, this, this.conn, this.preparedQuery);
        }
        return this.p6Statement;
    }
}

