/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.aspects.jdbc.p6spy;

import com.p6spy.engine.spy.P6Connection;
import com.p6spy.engine.spy.P6Statement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import net.sf.infrared.agent.MonitorFactory;
import net.sf.infrared.agent.StatisticsCollector;
import net.sf.infrared.aspects.api.ApiContext;
import net.sf.infrared.aspects.jdbc.SqlExecuteContext;
import net.sf.infrared.aspects.jdbc.p6spy.InfraREDP6Factory;
import net.sf.infrared.base.model.ExecutionTimer;

public class InfraREDP6Statement
implements Statement {
    protected InfraREDP6Factory factory;
    protected P6Connection conn;
    protected Statement passThru;
    protected String query;
    protected P6Statement p6Statement;

    public InfraREDP6Statement(InfraREDP6Factory infraP6Factory, Statement statement, P6Connection conn) {
        this.factory = infraP6Factory;
        this.conn = conn;
        this.passThru = statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet resultSet;
        this.query = sql;
        if (this.factory.isJDBCMonitoringEnabled()) {
            SqlExecuteContext executeCtx = this.factory.getSqlContext(sql).getExecuteContext();
            ExecutionTimer timer = new ExecutionTimer(executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                resultSet = this.passThru.executeQuery(sql);
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        } else {
            resultSet = this.passThru.executeQuery(sql);
        }
        return this.factory.getResultSet(resultSet, this.getP6Statement(), this.query, this.query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        this.query = sql;
        if (this.factory.isJDBCMonitoringEnabled()) {
            SqlExecuteContext executeCtx = this.factory.getSqlContext(sql).getExecuteContext();
            ExecutionTimer timer = new ExecutionTimer(executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                int n = this.passThru.executeUpdate(sql);
                return n;
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        }
        return this.passThru.executeUpdate(sql);
    }

    public void addBatch(String sql) throws SQLException {
        this.query = this.query + "; " + sql;
        this.passThru.addBatch(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        if (this.query == null) {
            return this.passThru.executeBatch();
        }
        if (this.factory.isJDBCMonitoringEnabled()) {
            SqlExecuteContext executeCtx = this.factory.getSqlContext(this.query).getExecuteContext();
            ExecutionTimer timer = new ExecutionTimer(executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                int[] nArray = this.passThru.executeBatch();
                return nArray;
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        }
        return this.passThru.executeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int p1) throws SQLException {
        if (this.factory.isJDBCMonitoringEnabled()) {
            SqlExecuteContext executeCtx = this.factory.getSqlContext(sql).getExecuteContext();
            ExecutionTimer timer = new ExecutionTimer(executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                int n = this.passThru.executeUpdate(sql, p1);
                return n;
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        }
        return this.passThru.executeUpdate(sql, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int[] p1) throws SQLException {
        if (this.factory.isJDBCMonitoringEnabled()) {
            SqlExecuteContext executeCtx = this.factory.getSqlContext(sql).getExecuteContext();
            ExecutionTimer timer = new ExecutionTimer(executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                int n = this.passThru.executeUpdate(sql, p1);
                return n;
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        }
        return this.passThru.executeUpdate(sql, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, String[] p1) throws SQLException {
        if (this.factory.isJDBCMonitoringEnabled()) {
            SqlExecuteContext executeCtx = this.factory.getSqlContext(sql).getExecuteContext();
            ExecutionTimer timer = new ExecutionTimer(executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                int n = this.passThru.executeUpdate(sql, p1);
                return n;
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        }
        return this.passThru.executeUpdate(sql, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int p1) throws SQLException {
        if (this.factory.isJDBCMonitoringEnabled()) {
            SqlExecuteContext executeCtx = this.factory.getExecuteContext(sql);
            ExecutionTimer timer = new ExecutionTimer(executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                boolean bl = this.passThru.execute(sql, p1);
                return bl;
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        }
        return this.passThru.execute(sql, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int[] p1) throws SQLException {
        if (this.factory.isJDBCMonitoringEnabled()) {
            SqlExecuteContext executeCtx = this.factory.getExecuteContext(sql);
            ExecutionTimer timer = new ExecutionTimer(executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                boolean bl = this.passThru.execute(sql, p1);
                return bl;
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        }
        return this.passThru.execute(sql, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, String[] p1) throws SQLException {
        if (this.factory.isJDBCMonitoringEnabled()) {
            SqlExecuteContext executeCtx = this.factory.getExecuteContext(sql);
            ExecutionTimer timer = new ExecutionTimer(executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                boolean bl = this.passThru.execute(sql, p1);
                return bl;
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        }
        return this.passThru.execute(sql, p1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.factory.isJDBCMonitoringEnabled()) {
            String methodName = "close";
            ApiContext ctx = new ApiContext(Statement.class.getName(), "close", "JDBC");
            ExecutionTimer timer = new ExecutionTimer(ctx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                this.passThru.close();
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        } else {
            this.passThru.close();
        }
    }

    public int getMaxFieldSize() throws SQLException {
        return this.passThru.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.passThru.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this.passThru.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this.passThru.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.passThru.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this.passThru.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.passThru.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this.passThru.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.passThru.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.passThru.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this.passThru.setCursorName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        if (this.factory.isJDBCMonitoringEnabled()) {
            SqlExecuteContext executeCtx = this.factory.getExecuteContext(sql);
            ExecutionTimer timer = new ExecutionTimer(executeCtx);
            StatisticsCollector col = MonitorFactory.getFacade().recordExecutionBegin(timer);
            try {
                boolean bl = this.passThru.execute(sql);
                return bl;
            }
            finally {
                MonitorFactory.getFacade().recordExecutionEnd(timer, col);
            }
        }
        return this.passThru.execute(sql);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.factory.getResultSet(this.passThru.getResultSet(), this.getP6Statement(), this.query, this.query);
    }

    public int getUpdateCount() throws SQLException {
        return this.passThru.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this.passThru.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.passThru.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this.passThru.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this.passThru.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this.passThru.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.passThru.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this.passThru.getResultSetType();
    }

    public void clearBatch() throws SQLException {
        this.passThru.clearBatch();
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.passThru.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.factory.getResultSet(this.passThru.getGeneratedKeys(), new P6Statement(this.factory, this, this.conn), "", this.query);
    }

    public int getResultSetHoldability() throws SQLException {
        return this.passThru.getResultSetHoldability();
    }

    protected P6Statement getP6Statement() {
        if (this.p6Statement == null) {
            this.p6Statement = new P6Statement(this.factory, this, this.conn);
        }
        return this.p6Statement;
    }
}

