/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.aspects.jsp;

import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.infrared.aspects.AbstractExecutionContext;

public class JspContext
extends AbstractExecutionContext {
    private static Properties cache = new Properties();
    private static final String JASPER_PREFIX = "org.apache.jsp.";
    private static final String WEBLOGIC_PREFIX = "jsp_servlet._";
    private String jspName;

    public JspContext(String jspClassName) {
        super("Jsp");
        this.jspName = jspClassName.startsWith(JASPER_PREFIX) ? JspContext.getJasperJspName(jspClassName) : (jspClassName.startsWith(WEBLOGIC_PREFIX) ? JspContext.getWeblogicJspName(jspClassName) : jspClassName);
    }

    public JspContext(Class jspClass) {
        this(jspClass.getName());
    }

    public JspContext(String name, String layer) {
        super(layer);
        this.jspName = name;
    }

    public String getName() {
        if (this.jspName == null) {
            // empty if block
        }
        return this.jspName;
    }

    public String toString() {
        return "Jsp " + this.getName();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof JspContext)) {
            return false;
        }
        JspContext other = (JspContext)o;
        return other.jspName.equals(this.jspName);
    }

    public int hashCode() {
        return 7 * this.jspName.hashCode();
    }

    static String getJasperJspName(String jspClassName) {
        String jspName = (String)cache.get(jspClassName);
        if (jspName != null) {
            return jspName;
        }
        jspName = jspClassName.substring(JASPER_PREFIX.length());
        jspName = jspName.replace('.', '/');
        Pattern pattern = Pattern.compile("_[a-f0-9]{4}");
        Matcher matcher = pattern.matcher(jspName);
        int findFrom = 0;
        while (matcher.find(findFrom)) {
            findFrom = matcher.start() + 1;
            String mangledSpecialChar = matcher.group();
            mangledSpecialChar = mangledSpecialChar.substring(1, mangledSpecialChar.length());
            String unmangedSpecialChar = JspContext.getUnmangedSpecialChar(mangledSpecialChar);
            jspName = jspName.replaceAll("_" + mangledSpecialChar, unmangedSpecialChar);
            matcher = pattern.matcher(jspName);
        }
        jspName = jspName.substring(0, jspName.length() - 4);
        jspName = jspName + ".jsp";
        cache.put(jspClassName, jspName);
        return jspName;
    }

    static String getWeblogicJspName(String jspClassName) {
        String jspName = (String)cache.get(jspClassName);
        if (jspName != null) {
            return jspName;
        }
        jspName = jspClassName.substring(WEBLOGIC_PREFIX.length());
        jspName = jspName.replaceAll("\\._", "/");
        Pattern pattern = Pattern.compile("_[0-9]+_");
        Matcher matcher = pattern.matcher(jspName);
        while (matcher.find()) {
            String specialCharMangle = matcher.group();
            specialCharMangle = specialCharMangle.substring(1, specialCharMangle.length() - 1);
            int ch = Integer.parseInt(specialCharMangle);
            jspName = jspName.replaceAll("_" + specialCharMangle + "_", String.valueOf((char)ch));
            matcher = pattern.matcher(jspName);
        }
        jspName = jspName.replaceAll("/_", "/");
        jspName = jspName.replaceAll("^_", "");
        jspName = jspName + ".jsp";
        cache.put(jspClassName, jspName);
        return jspName;
    }

    static String getUnmangedSpecialChar(String mangled) {
        char ch = mangled.charAt(0);
        int hex0 = Character.digit(ch, 16);
        ch = mangled.charAt(1);
        int hex1 = Character.digit(ch, 16);
        ch = mangled.charAt(2);
        int hex2 = Character.digit(ch, 16);
        ch = mangled.charAt(3);
        int hex3 = Character.digit(ch, 16);
        int sum = 4096 * hex0 + 256 * hex1 + 16 * hex2 + hex3;
        return new String(new char[]{(char)sum});
    }
}

