/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.base.model;

import java.io.Serializable;
import net.sf.infrared.base.model.ExecutionContext;
import net.sf.infrared.base.model.ExecutionTimer;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.org.apache.log4j.Logger;

public class AggregateExecutionTime
implements Cloneable,
Serializable {
    private static final Logger log;
    private ExecutionContext ctx;
    private int count = 0;
    private long totalInclusiveTime = 0L;
    private long maxInclusiveTime = Long.MIN_VALUE;
    private long minInclusiveTime = Long.MAX_VALUE;
    private long totalExclusiveTime = 0L;
    private long maxExclusiveTime = Long.MIN_VALUE;
    private long minExclusiveTime = Long.MAX_VALUE;
    private long timeOfFirstExecution = Long.MAX_VALUE;
    private long timeOfLastExecution = -1L;
    private long inclusiveFirstExecutionTime = -1L;
    private long inclusiveLastExecutionTime = -1L;
    private long exclusiveFirstExecutionTime = -1L;
    private long exclusiveLastExecutionTime = -1L;
    private String layerName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AggregateExecutionTime(ExecutionContext ctx) {
        if (!$assertionsDisabled && ctx == null) {
            throw new AssertionError((Object)"Cannot create AggregateExecutionTime with null ExecutionContext");
        }
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(AggregateExecutionTime aet) {
        if (!$assertionsDisabled && !this.getContext().equals(aet.getContext())) {
            throw new AssertionError((Object)("Illegal attempt to merge two AggregateExecutionTimes representing different contexts[ " + this.getContext() + ", " + aet.getContext() + " ]"));
        }
        AggregateExecutionTime aggregateExecutionTime = this;
        synchronized (aggregateExecutionTime) {
            this.mergeExecutionCount(aet);
            this.mergeInclusiveTime(aet);
            this.mergeExclusiveTime(aet);
            this.mergeFirstExecution(aet);
            this.mergeLastExecution(aet);
            if (this.getLayerName() == null) {
                this.layerName = aet.getLayerName();
            }
            if (!$assertionsDisabled && !this.getLayerName().equals(aet.getLayerName())) {
                throw new AssertionError((Object)("Illegal attempt to merge two AggregateExecutionTimes executed under two layers[ " + this.getLayerName() + ", " + aet.getLayerName() + " ]"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(this + " - Merged " + aet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(ExecutionTimer et) {
        if (!$assertionsDisabled && !this.ctx.equals(et.getContext())) {
            throw new AssertionError((Object)("Illegal attempt to merge an ExecutionTime representing a different context[ " + et.getContext() + " ] than this one[ " + this.ctx + " ]"));
        }
        long inc = et.getInclusiveTime();
        long exc = et.getExclusiveTime();
        AggregateExecutionTime aggregateExecutionTime = this;
        synchronized (aggregateExecutionTime) {
            this.mergeExecutionCount(1);
            this.mergeInclusiveTime(inc, inc, inc);
            this.mergeExclusiveTime(exc, exc, exc);
            this.mergeFirstExecution(et.getStartTime(), inc, exc);
            this.mergeLastExecution(et.getStartTime(), inc, exc);
            if (this.getLayerName() == null) {
                this.setLayerName(et.getLayerName());
            }
            if (!$assertionsDisabled && !this.getLayerName().equals(et.getLayerName())) {
                throw new AssertionError((Object)("Illegal attempt to merge two AggregateExecutionTimes executed under two layers[ " + this.getLayerName() + ", " + et.getLayerName() + " ]"));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(this + " - Merged " + et);
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            log.error("CloneNotSupportedException should never be thrown here", e);
            return null;
        }
    }

    public String toString() {
        return "AggregateExecutionTime for " + this.ctx + "[ total inclusive time = " + this.totalInclusiveTime + ", " + "total exclusive time = " + this.totalExclusiveTime + ", " + "execution count = " + this.count + " ]";
    }

    public ExecutionContext getContext() {
        return this.ctx;
    }

    public int getExecutionCount() {
        return this.count;
    }

    public long getTimeOfFirstExecution() {
        return this.timeOfFirstExecution;
    }

    public long getInclusiveFirstExecutionTime() {
        return this.inclusiveFirstExecutionTime;
    }

    public long getExclusiveFirstExecutionTime() {
        return this.exclusiveFirstExecutionTime;
    }

    public long getTimeOfLastExecution() {
        return this.timeOfLastExecution;
    }

    public long getInclusiveLastExecutionTime() {
        return this.inclusiveLastExecutionTime;
    }

    public long getExclusiveLastExecutionTime() {
        return this.exclusiveLastExecutionTime;
    }

    public long getTotalInclusiveTime() {
        return this.totalInclusiveTime;
    }

    public long getTotalExclusiveTime() {
        return this.totalExclusiveTime;
    }

    public long getMaxInclusiveTime() {
        return this.maxInclusiveTime;
    }

    public long getMinInclusiveTime() {
        return this.minInclusiveTime;
    }

    public long getMaxExclusiveTime() {
        return this.maxExclusiveTime;
    }

    public long getMinExclusiveTime() {
        return this.minExclusiveTime;
    }

    public double getAverageInclusiveTime() {
        if (this.getExecutionCount() == 0) {
            return 0.0;
        }
        return (double)this.getTotalInclusiveTime() / (double)this.getExecutionCount();
    }

    public double getAverageExclusiveTime() {
        if (this.getExecutionCount() == 0) {
            return 0.0;
        }
        return (double)this.getTotalExclusiveTime() / (double)this.getExecutionCount();
    }

    public double getAdjAverageInclusiveTime() {
        if (this.getExecutionCount() <= 1) {
            return this.getAverageInclusiveTime();
        }
        return (double)(this.getTotalInclusiveTime() - this.getInclusiveFirstExecutionTime()) / (double)(this.getExecutionCount() - 1);
    }

    public double getAdjAverageExclusiveTime() {
        if (this.getExecutionCount() <= 1) {
            return this.getAverageExclusiveTime();
        }
        return (double)(this.getTotalExclusiveTime() - this.getExclusiveFirstExecutionTime()) / (double)(this.getExecutionCount() - 1);
    }

    public String getName() {
        return this.getContext().getName();
    }

    void mergeExecutionCount(AggregateExecutionTime aet) {
        this.mergeExecutionCount(aet.getExecutionCount());
    }

    void mergeExecutionCount(int c) {
        this.count += c;
    }

    void mergeTotalTimes(AggregateExecutionTime aet) {
        this.mergeTotalTimes(aet.getTotalInclusiveTime(), aet.getTotalExclusiveTime());
    }

    void mergeTotalTimes(long totalInclusiveTime, long totalExclusiveTime) {
        this.totalInclusiveTime += totalInclusiveTime;
        this.totalExclusiveTime += totalExclusiveTime;
    }

    void mergeFirstExecution(AggregateExecutionTime aet) {
        this.mergeFirstExecution(aet.timeOfFirstExecution, aet.inclusiveFirstExecutionTime, aet.exclusiveFirstExecutionTime);
    }

    void mergeFirstExecution(long timeOfFirstExecution, long inclusiveTime, long exclusiveTime) {
        if (timeOfFirstExecution < this.timeOfFirstExecution) {
            this.timeOfFirstExecution = timeOfFirstExecution;
            this.inclusiveFirstExecutionTime = inclusiveTime;
            this.exclusiveFirstExecutionTime = exclusiveTime;
        }
    }

    void mergeLastExecution(AggregateExecutionTime aet) {
        this.mergeLastExecution(aet.getTimeOfLastExecution(), aet.getInclusiveLastExecutionTime(), aet.getExclusiveLastExecutionTime());
    }

    void mergeLastExecution(long timeOfLastExecution, long inclusiveTime, long exclusiveTime) {
        if (this.timeOfLastExecution < timeOfLastExecution) {
            this.timeOfLastExecution = timeOfLastExecution;
            this.inclusiveLastExecutionTime = inclusiveTime;
            this.exclusiveLastExecutionTime = exclusiveTime;
        }
    }

    void mergeInclusiveTime(AggregateExecutionTime e) {
        this.mergeInclusiveTime(e.getMaxInclusiveTime(), e.getMinInclusiveTime(), e.getTotalInclusiveTime());
    }

    void mergeInclusiveTime(long max, long min, long total) {
        this.minInclusiveTime = Math.min(this.minInclusiveTime, min);
        this.maxInclusiveTime = Math.max(this.maxInclusiveTime, max);
        this.totalInclusiveTime += total;
    }

    void mergeExclusiveTime(AggregateExecutionTime e) {
        this.mergeExclusiveTime(e.getMaxExclusiveTime(), e.getMinExclusiveTime(), e.getTotalExclusiveTime());
    }

    void mergeExclusiveTime(long max, long min, long total) {
        this.minExclusiveTime = Math.min(this.minExclusiveTime, min);
        this.maxExclusiveTime = Math.max(this.maxExclusiveTime, max);
        this.totalExclusiveTime += total;
    }

    public void setExclusiveFirstExecutionTime(long exclusiveFirstExecutionTime) {
        this.exclusiveFirstExecutionTime = exclusiveFirstExecutionTime;
    }

    public void setExclusiveLastExecutionTime(long exclusiveLastExecutionTime) {
        this.exclusiveLastExecutionTime = exclusiveLastExecutionTime;
    }

    public void setInclusiveFirstExecutionTime(long inclusiveFirstExecutionTime) {
        this.inclusiveFirstExecutionTime = inclusiveFirstExecutionTime;
    }

    public void setInclusiveLastExecutionTime(long inclusiveLastExecutionTime) {
        this.inclusiveLastExecutionTime = inclusiveLastExecutionTime;
    }

    public void setMaxExclusiveTime(long maxExclusiveTime) {
        this.maxExclusiveTime = maxExclusiveTime;
    }

    public void setMaxInclusiveTime(long maxInclusiveTime) {
        this.maxInclusiveTime = maxInclusiveTime;
    }

    public void setMinExclusiveTime(long minExclusiveTime) {
        this.minExclusiveTime = minExclusiveTime;
    }

    public void setMinInclusiveTime(long minInclusiveTime) {
        this.minInclusiveTime = minInclusiveTime;
    }

    public void setTimeOfFirstExecution(long timeOfFirstExecution) {
        this.timeOfFirstExecution = timeOfFirstExecution;
    }

    public void setTimeOfLastExecution(long timeOfLastExecution) {
        this.timeOfLastExecution = timeOfLastExecution;
    }

    public void setTotalExclusiveTime(long totalExclusiveTime) {
        this.totalExclusiveTime = totalExclusiveTime;
    }

    public void setTotalInclusiveTime(long totalInclusiveTime) {
        this.totalInclusiveTime = totalInclusiveTime;
    }

    public void setExecutionCount(int c) {
        this.count = c;
    }

    public void setContext(ExecutionContext context) {
        this.ctx = context;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layer) {
        this.layerName = layer;
    }

    static {
        $assertionsDisabled = !AggregateExecutionTime.class.desiredAssertionStatus();
        log = LoggingFactory.getLogger(AggregateExecutionTime.class);
    }
}

