/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.base.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import net.sf.infrared.base.model.AggregateOperationTreeMerger;
import net.sf.infrared.base.model.OperationTreeMerger;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.base.util.Merger;
import net.sf.infrared.base.util.Tree;
import net.sf.infrared.base.util.TreeNode;
import net.sf.infrared.org.apache.log4j.Logger;

public class AggregateOperationTree
implements Serializable {
    private static final Logger log = LoggingFactory.getLogger(AggregateOperationTree.class);
    private Tree aggregateTree;
    private Merger opMerger = new OperationTreeMerger();
    private Merger aggMerger = new AggregateOperationTreeMerger();

    public AggregateOperationTree() {
        this.aggregateTree = new Tree();
        this.aggregateTree.setRoot(TreeNode.createTreeNode("dummy root"));
    }

    public synchronized void merge(Tree anOperation) {
        this.aggregateTree.getRoot().mergeAsChild(anOperation.getRoot(), this.opMerger);
        if (log.isDebugEnabled()) {
            log.debug("Merged operation tree with root " + anOperation.getRoot().getValue());
        }
    }

    public synchronized void merge(AggregateOperationTree otherTree) {
        List othersChildren = otherTree.getAggregateTree().getRoot().getChildren();
        TreeNode rootOfThis = this.getAggregateTree().getRoot();
        Iterator iter = othersChildren.iterator();
        while (iter.hasNext()) {
            TreeNode othersChild = (TreeNode)iter.next();
            rootOfThis.mergeAsChild(othersChild, this.aggMerger);
        }
        if (log.isDebugEnabled()) {
            log.debug(this + " - Merged AggregateOperationTree " + otherTree);
        }
    }

    public String toString() {
        return this.aggregateTree.getRoot().toString();
    }

    public Tree getAggregateTree() {
        return this.aggregateTree;
    }

    public void setAggregateTree(Tree aggregateTree) {
        this.aggregateTree = aggregateTree;
    }
}

