/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.base.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.infrared.base.model.AbstractStatistics;
import net.sf.infrared.base.model.AggregateExecutionTime;
import net.sf.infrared.base.model.AggregateOperationTree;
import net.sf.infrared.base.model.ExecutionTimer;
import net.sf.infrared.base.model.LayerTimeRepository;
import net.sf.infrared.base.model.OperationStatistics;
import net.sf.infrared.base.util.Tree;

public class ApplicationStatistics
extends AbstractStatistics {
    private static final int DEFAULT_MAX_LAST_INVOCATIONS = 5;
    private AggregateOperationTree tree;
    private boolean hasStatistics = false;
    private int maxLastInvocations = 5;
    private LinkedList lastInvocationsList;
    private long startTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;
    private LayerTimeRepository repository;

    public ApplicationStatistics(String applicationName, String instanceId) {
        super(applicationName, instanceId);
        this.reset();
    }

    public synchronized void reset() {
        this.repository = new LayerTimeRepository();
        this.hasStatistics = false;
        this.tree = new AggregateOperationTree();
        this.lastInvocationsList = new LinkedList();
        this.startTime = Long.MAX_VALUE;
        this.endTime = Long.MIN_VALUE;
    }

    public synchronized void merge(OperationStatistics opStats) {
        if (opStats == null) {
            return;
        }
        if (!this.getApplicationName().equals(opStats.getApplicationName()) || !this.getInstanceId().equals(opStats.getInstanceId())) {
            throw new IllegalArgumentException("Incorrect application name or instanceId: Can't merge " + opStats + " to " + this);
        }
        this.mergeStartAndEndTimes(opStats);
        this.mergeLayerAndExecutionTimes(opStats);
        Tree tree = opStats.getOperationTree();
        this.addToLastInvocations(tree);
        this.mergeTree(tree);
    }

    public synchronized void merge(ApplicationStatistics otherStats) {
        if (otherStats == null) {
            return;
        }
        if (!this.getApplicationName().equals(otherStats.getApplicationName()) || !this.getInstanceId().equals(otherStats.getInstanceId())) {
            throw new IllegalArgumentException("Incorrect application name or instanceId: Can't merge " + otherStats + " to " + this);
        }
        this.mergeStartAndEndTimes(otherStats);
        this.mergeLayerAndExecutionTimes(otherStats);
        AggregateOperationTree tree = otherStats.getTree();
        this.mergeTree(tree);
        this.addToLastInvocations(otherStats.getLastInvocations());
    }

    public boolean hasStatistics() {
        return this.hasStatistics;
    }

    public List getLastInvocations() {
        return Collections.unmodifiableList(this.lastInvocationsList);
    }

    public AggregateOperationTree getTree() {
        return this.tree;
    }

    public int getMaxLastInvocations() {
        return this.maxLastInvocations;
    }

    public void setMaxLastInvocations(int max) {
        this.maxLastInvocations = max;
    }

    public String[] getLayers() {
        return this.repository.getHierarchicalLayers();
    }

    public long getTimeInLayer(String layer) {
        return this.repository.getTimeInHierarchicalLayer(layer);
    }

    public AggregateExecutionTime[] getExecutionsInLayer(String layer) {
        return this.repository.getExecutionsInHierarchicalLayer(layer);
    }

    public String toString() {
        return "Application Statistics[app=" + this.getApplicationName() + ", inst=" + this.getInstanceId() + "] from " + this.startTime + ", until " + this.endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    void addToLastInvocations(Tree opTree) {
        if (opTree == null) {
            return;
        }
        if (this.lastInvocationsList.size() >= this.maxLastInvocations) {
            this.lastInvocationsList.removeLast();
        }
        this.lastInvocationsList.addFirst(opTree);
        this.hasStatistics = true;
    }

    void addToLastInvocations(List trees) {
        Iterator i = trees.iterator();
        while (i.hasNext()) {
            this.addToLastInvocations((Tree)i.next());
        }
    }

    void mergeTree(Tree opTree) {
        if (opTree == null) {
            return;
        }
        this.tree.merge(opTree);
        this.hasStatistics = true;
    }

    void mergeTree(AggregateOperationTree aggTree) {
        if (aggTree == null) {
            return;
        }
        this.tree.merge(aggTree);
        this.hasStatistics = true;
    }

    void mergeStartAndEndTimes(OperationStatistics stats) {
        this.mergeStartAndEndTimes(stats.getStartTime(), stats.getEndTime());
    }

    void mergeStartAndEndTimes(ApplicationStatistics stats) {
        this.mergeStartAndEndTimes(stats.getStartTime(), stats.getEndTime());
    }

    void mergeStartAndEndTimes(long othersStartTime, long othersEndTime) {
        this.startTime = Math.min(this.startTime, othersStartTime);
        this.endTime = Math.max(this.endTime, othersEndTime);
    }

    void mergeLayerAndExecutionTimes(OperationStatistics stats) {
        String[] layers = stats.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            String aLayer = layers[i];
            this.mergeLayerTime(aLayer, stats.getTimeInLayer(aLayer));
            this.mergeExecutionTimes(aLayer, stats.getExecutions(aLayer));
        }
    }

    void mergeLayerAndExecutionTimes(ApplicationStatistics stats) {
        String[] layers = stats.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            String aLayer = layers[i];
            this.mergeLayerTime(aLayer, stats.getTimeInLayer(aLayer));
            this.mergeExecutionTimes(aLayer, stats.getExecutionsInLayer(aLayer));
        }
    }

    void mergeLayerTime(String layer, long time) {
        this.repository.mergeHierarchicalLayerTime(layer, time);
        this.hasStatistics = true;
    }

    void mergeExecutionTimes(String layerName, ExecutionTimer[] times) {
        this.repository.mergeExecutionTimes(layerName, times);
        this.hasStatistics = true;
    }

    void mergeExecutionTimes(String layerName, AggregateExecutionTime[] times) {
        this.repository.mergeExecutionTimes(layerName, times);
        this.hasStatistics = true;
    }
}

