/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.base.model;

import java.io.Serializable;
import net.sf.infrared.base.model.ExecutionContext;

public class ExecutionTimer
implements Serializable {
    private ExecutionContext ctx;
    private long startTime = -1L;
    private long endTime = -1L;
    private long inclusiveTime = 0L;
    private long exclusiveTime = 0L;
    private String layerName;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExecutionTimer(ExecutionContext ctx) {
        this.ctx = ctx;
    }

    ExecutionTimer() {
    }

    public void start() {
        if (!$assertionsDisabled && this.isExecuting()) {
            throw new AssertionError((Object)"Cannot start an already started ExecutionTimer");
        }
        this.startTime = this.getCurrentTime();
    }

    public void stop() {
        if (!$assertionsDisabled && !this.isExecuting()) {
            throw new AssertionError((Object)"Cannot stop an ExecutionTimer which hasnt started");
        }
        this.endTime = this.getCurrentTime();
        this.inclusiveTime = this.endTime - this.startTime;
    }

    public void setExclusiveTime(long time) {
        if (!$assertionsDisabled && this.getInclusiveTime() >= time) {
            throw new AssertionError((Object)("exclusive time " + time + " cannot be greater than inclusive time " + this.inclusiveTime));
        }
        this.exclusiveTime = time;
    }

    public long getInclusiveTime() {
        return this.inclusiveTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public ExecutionContext getContext() {
        return this.ctx;
    }

    public long getExclusiveTime() {
        return this.exclusiveTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return "ExecutionTime for " + this.ctx + "(inclusive time = " + this.inclusiveTime + ", " + "exclusive time = " + this.exclusiveTime + ")";
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layer) {
        this.layerName = layer;
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    boolean isExecuting() {
        return this.startTime != -1L && this.endTime == -1L;
    }

    boolean hasFinishedExecution() {
        return this.endTime != -1L;
    }

    void setInclusiveTime(long time) {
        this.inclusiveTime = time;
    }

    static {
        $assertionsDisabled = !ExecutionTimer.class.desiredAssertionStatus();
    }
}

