/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.base.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.infrared.base.model.AggregateExecutionTime;
import net.sf.infrared.base.model.ExecutionContext;
import net.sf.infrared.base.model.ExecutionTimer;
import net.sf.infrared.base.model.LayerTime;

public class LayerTimeRepository
implements Serializable,
Cloneable {
    private Map hierarchicalLayerTimes = new HashMap();
    private Map hierarchicalAggExecTimes = new HashMap();

    public String[] getHierarchicalLayers() {
        HashSet ret = new HashSet();
        ret.addAll(this.hierarchicalLayerTimes.keySet());
        ret.addAll(this.hierarchicalAggExecTimes.keySet());
        return ret.toArray(new String[ret.size()]);
    }

    public String[] getAbsoluteLayers() {
        String[] hLayers = this.getHierarchicalLayers();
        HashSet aLayers = new HashSet();
        for (int i = 0; i < hLayers.length; ++i) {
            String hLayer = hLayers[i];
            aLayers.addAll(this.parseAbsoluteLayers(hLayer));
        }
        return aLayers.toArray(new String[aLayers.size()]);
    }

    public long getTimeInHierarchicalLayer(String hLayer) {
        return this.getLayerTimeFromMap(this.hierarchicalLayerTimes, hLayer);
    }

    public long getTimeInAbsoluteLayer(String aLayer) {
        String dotPrefixedLayer = "." + aLayer;
        long time = 0L;
        String[] hLayers = this.getHierarchicalLayers();
        for (int i = 0; i < hLayers.length; ++i) {
            String hLayer = hLayers[i];
            if (!hLayer.equals(aLayer) && !hLayer.endsWith(dotPrefixedLayer)) continue;
            time += this.getTimeInHierarchicalLayer(hLayer);
        }
        return time;
    }

    public AggregateExecutionTime[] getExecutionsInHierarchicalLayer(String hLayer) {
        return this.getExecutionsFromMap(this.hierarchicalAggExecTimes, hLayer);
    }

    public AggregateExecutionTime[] getExecutionsInAbsoluteLayer(String aLayer) {
        HashMap<ExecutionContext, AggregateExecutionTime> ctxToAggExecs = new HashMap<ExecutionContext, AggregateExecutionTime>();
        String[] hLayers = this.getHierarchicalLayers();
        for (int i = 0; i < hLayers.length; ++i) {
            String hLayer = hLayers[i];
            AggregateExecutionTime[] aets = this.getExecutionsInHierarchicalLayer(hLayer);
            for (int j = 0; j < aets.length; ++j) {
                AggregateExecutionTime aet = aets[j];
                ExecutionContext ctx = aet.getContext();
                if (!ctx.getLayer().equals(aLayer)) continue;
                AggregateExecutionTime merged = (AggregateExecutionTime)ctxToAggExecs.get(ctx);
                if (merged == null) {
                    merged = new AggregateExecutionTime(ctx);
                    ctxToAggExecs.put(ctx, merged);
                }
                merged.merge(aet);
            }
        }
        return ctxToAggExecs.values().toArray(new AggregateExecutionTime[0]);
    }

    public void mergeHierarchicalLayerTime(String layerName, long time) {
        this.getAggregateHierarchicalLayerTime(layerName).addToTime(time);
    }

    public void mergeHierarchicalLayerTime(LayerTime lt) {
        this.mergeHierarchicalLayerTime(lt.getLayer(), lt.getTime());
    }

    public void mergeExecutionTimes(String hLayer, ExecutionTimer[] times) {
        for (int i = 0; i < times.length; ++i) {
            ExecutionTimer et = times[i];
            this.getAggregateExecutionTime(hLayer, et.getContext()).merge(et);
        }
    }

    public void mergeExecutionTimes(String layerName, AggregateExecutionTime[] times) {
        for (int i = 0; i < times.length; ++i) {
            AggregateExecutionTime aet = times[i];
            this.getAggregateExecutionTime(layerName, aet.getContext()).merge(aet);
        }
    }

    LayerTime getAggregateHierarchicalLayerTime(String layer) {
        LayerTime lt = (LayerTime)this.hierarchicalLayerTimes.get(layer);
        if (lt == null) {
            lt = new LayerTime(layer);
            this.hierarchicalLayerTimes.put(layer, lt);
        }
        return lt;
    }

    AggregateExecutionTime getAggregateExecutionTime(String hLayer, ExecutionContext ctx) {
        HashMap<ExecutionContext, AggregateExecutionTime> m = (HashMap<ExecutionContext, AggregateExecutionTime>)this.hierarchicalAggExecTimes.get(hLayer);
        if (m == null) {
            m = new HashMap<ExecutionContext, AggregateExecutionTime>();
            this.hierarchicalAggExecTimes.put(hLayer, m);
            AggregateExecutionTime aet = new AggregateExecutionTime(ctx);
            m.put(ctx, aet);
            return aet;
        }
        AggregateExecutionTime aet = (AggregateExecutionTime)m.get(ctx);
        if (aet == null) {
            aet = new AggregateExecutionTime(ctx);
            m.put(ctx, aet);
        }
        return aet;
    }

    long getLayerTimeFromMap(Map map, String l) {
        LayerTime lt = (LayerTime)map.get(l);
        if (lt != null) {
            return lt.getTime();
        }
        return 0L;
    }

    AggregateExecutionTime[] getExecutionsFromMap(Map map, String l) {
        Map innerMap = (Map)map.get(l);
        if (innerMap == null) {
            return new AggregateExecutionTime[0];
        }
        return innerMap.values().toArray(new AggregateExecutionTime[0]);
    }

    Collection parseAbsoluteLayers(String hLayer) {
        HashSet<String> absLayers = new HashSet<String>();
        Pattern p = Pattern.compile("[\\w]+[\\.]");
        Matcher m = p.matcher(hLayer);
        int i = 0;
        while (m.find(i)) {
            i = m.end();
            String aLayer = m.group();
            aLayer = aLayer.substring(0, aLayer.length() - 1);
            absLayers.add(aLayer);
        }
        absLayers.add(hLayer.substring(i));
        return absLayers;
    }
}

