/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.base.model;

import java.util.List;
import java.util.Map;
import net.sf.infrared.base.model.AbstractStatistics;
import net.sf.infrared.base.model.ExecutionTimer;
import net.sf.infrared.base.model.LayerTime;
import net.sf.infrared.base.util.Tree;

public class OperationStatistics
extends AbstractStatistics {
    private Tree operationTree;
    private Map executions;
    private Map layers;
    private long startTime = -1L;
    private long endTime = -1L;
    private int numOfExecsTracked = 0;
    private int numOfExecsIgnored = 0;

    public OperationStatistics(String application, String instance) {
        super(application, instance);
    }

    public Tree getOperationTree() {
        return this.operationTree;
    }

    public void setOperationTree(Tree tree) {
        if (this.operationTree != null) {
            throw new IllegalStateException("operation tree is already set; can't set it again");
        }
        this.operationTree = tree;
    }

    public void setLayerTimes(Map layerTimes) {
        this.layers = layerTimes;
    }

    public void setExecutionTimes(Map executionTimes) {
        this.executions = executionTimes;
    }

    public void setNumOfExecutions(int tracked, int ignored) {
        this.numOfExecsTracked = tracked;
        this.numOfExecsIgnored = ignored;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long time) {
        if (this.endTime != -1L) {
            throw new IllegalStateException("end time is already set; can't set again");
        }
        this.endTime = time;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long time) {
        if (this.startTime != -1L) {
            throw new IllegalStateException("start time is already set; can't set again");
        }
        this.startTime = time;
    }

    public String[] getLayers() {
        if (this.layers == null) {
            return new String[0];
        }
        return this.layers.keySet().toArray(new String[0]);
    }

    public long getTimeInLayer(String layerName) {
        LayerTime lt = (LayerTime)this.layers.get(layerName);
        if (lt == null) {
            return -1L;
        }
        return lt.getTime();
    }

    public ExecutionTimer[] getExecutions(String layerName) {
        List l = (List)this.executions.get(layerName);
        if (l == null) {
            return new ExecutionTimer[0];
        }
        return l.toArray(new ExecutionTimer[0]);
    }

    public String toString() {
        return "OperationStatistics[" + this.getApplicationName() + " on " + this.getInstanceId() + "] started at " + this.getStartTime() + ", ended at " + this.getEndTime() + "; captured " + this.numOfExecsTracked + " executions; ignored " + this.numOfExecsIgnored + "ignored";
    }
}

