/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.base.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.infrared.base.model.AggregateExecutionTime;
import net.sf.infrared.base.model.AggregateOperationTree;
import net.sf.infrared.base.model.ApplicationStatistics;
import net.sf.infrared.base.model.LayerTime;
import net.sf.infrared.base.model.LayerTimeRepository;

public class StatisticsSnapshot
implements Serializable,
Cloneable {
    private static final int DEFAULT_MAX_LAST_INVOCATIONS = 5;
    private static final String SEPERATOR = " - on - ";
    private Set applicationNames = new HashSet();
    private AggregateOperationTree tree = new AggregateOperationTree();
    private LayerTimeRepository repository = new LayerTimeRepository();
    private boolean hasStatistics = false;
    private int maxLastInvocations = 5;
    private LinkedList lastInvocationsList = new LinkedList();
    private long startTime = Long.MAX_VALUE;
    private long endTime = Long.MIN_VALUE;

    public synchronized void merge(ApplicationStatistics stats) {
        if (stats == null) {
            return;
        }
        this.applicationNames.add(this.getApplicationName(stats));
        this.mergeStartAndEndTimes(stats);
        this.mergeLayerAndExecutionTimes(stats);
        AggregateOperationTree tree = stats.getTree();
        this.mergeTree(tree);
        this.addToLastInvocations(stats.getLastInvocations());
    }

    public List getLastInvocations() {
        return Collections.unmodifiableList(this.lastInvocationsList);
    }

    public void setMaxLastInvocations(int max) {
        this.maxLastInvocations = max;
    }

    public AggregateOperationTree getTree() {
        return this.tree;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String[] getHierarchicalLayers() {
        return this.repository.getHierarchicalLayers();
    }

    public String[] getAbsoluteLayers() {
        return this.repository.getAbsoluteLayers();
    }

    public long getTimeInHierarchicalLayer(String hLayer) {
        return this.repository.getTimeInHierarchicalLayer(hLayer);
    }

    public long getTimeInAbsoluteLayer(String aLayer) {
        return this.repository.getTimeInAbsoluteLayer(aLayer);
    }

    public AggregateExecutionTime[] getExecutionsInHierarchicalLayer(String hLayer) {
        return this.repository.getExecutionsInHierarchicalLayer(hLayer);
    }

    public AggregateExecutionTime[] getExecutionsInAbsoluteLayer(String aLayer) {
        return this.repository.getExecutionsInAbsoluteLayer(aLayer);
    }

    public Set getApplicationNames() {
        return Collections.unmodifiableSet(this.applicationNames);
    }

    public static StatisticsSnapshot createSnapshot(Collection appNames, Collection instanceIds, Map layerTimes, Map executionTimes, AggregateOperationTree tree, long startTime, long endTime) {
        String layer;
        Map.Entry entry;
        StatisticsSnapshot stats = new StatisticsSnapshot();
        Iterator i = layerTimes.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            layer = (String)entry.getKey();
            LayerTime lt = (LayerTime)entry.getValue();
            stats.mergeLayerTime(layer, lt.getTime());
        }
        i = executionTimes.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            layer = (String)entry.getKey();
            List executions = (List)entry.getValue();
            stats.mergeExecutionTimes(layer, executions.toArray(new AggregateExecutionTime[0]));
        }
        stats.tree = tree;
        stats.startTime = startTime;
        stats.endTime = endTime;
        stats.applicationNames = new HashSet(appNames);
        return stats;
    }

    String getApplicationName(ApplicationStatistics stats) {
        return stats.getApplicationName() + SEPERATOR + stats.getInstanceId();
    }

    void mergeTree(AggregateOperationTree tree) {
        if (tree != null) {
            this.tree.merge(tree);
            this.hasStatistics = true;
        }
    }

    void mergeLayerAndExecutionTimes(ApplicationStatistics stats) {
        String[] layers = stats.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            String aLayer = layers[i];
            this.mergeLayerTime(aLayer, stats.getTimeInLayer(aLayer));
            this.mergeExecutionTimes(aLayer, stats.getExecutionsInLayer(aLayer));
        }
    }

    void mergeLayerTime(String layerName, long time) {
        this.repository.mergeHierarchicalLayerTime(layerName, time);
        this.hasStatistics = true;
    }

    void mergeExecutionTimes(String layerName, AggregateExecutionTime[] times) {
        this.repository.mergeExecutionTimes(layerName, times);
        this.hasStatistics = true;
    }

    void mergeStartAndEndTimes(ApplicationStatistics stats) {
        this.startTime = Math.min(this.startTime, stats.getStartTime());
        this.endTime = Math.max(this.endTime, stats.getEndTime());
    }

    void addToLastInvocations(List trees) {
        if (trees == null || trees.isEmpty()) {
            return;
        }
        this.lastInvocationsList.addAll(trees);
        int size = this.lastInvocationsList.size();
        if (size > this.maxLastInvocations) {
            for (int i = size; i > this.maxLastInvocations; --i) {
                this.lastInvocationsList.removeFirst();
            }
        }
        this.hasStatistics = true;
    }
}

