/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.base.util;

import java.net.URL;
import net.sf.infrared.base.util.LoggerDecorator;
import net.sf.infrared.org.apache.log4j.Logger;
import net.sf.infrared.org.apache.log4j.xml.DOMConfigurator;

public class LoggingFactory {
    public static final String DEBUG_KEY = "infrared.debug";
    public static final String INFO_KEY = "infrared.info";
    public static final String LOG4J_CONF = "infrared-log4j.xml";
    public static final String DEFAULT_CONF = "default-infrared-log4j.xml";
    private static URL log4jUrl = null;
    private static boolean isLoggingConfigured = false;
    private static boolean isUsingDefault = false;

    public static Logger getLogger(Class clazz) {
        LoggerDecorator wrapper = new LoggerDecorator(Logger.getLogger(clazz));
        return wrapper;
    }

    public static Logger getLogger(String loggerName) {
        LoggerDecorator wrapper = new LoggerDecorator(Logger.getLogger(loggerName));
        return wrapper;
    }

    public static URL getLoggingConfiguration() {
        return log4jUrl;
    }

    public static boolean isLoggingConfigured() {
        return isLoggingConfigured;
    }

    public static boolean isDefultLoggingUsed() {
        return isUsingDefault;
    }

    public static boolean isDebugLoggingEnabled() {
        return LoggingFactory.isInfoLoggingEnabled() || Boolean.getBoolean(DEBUG_KEY);
    }

    public static boolean isInfoLoggingEnabled() {
        return Boolean.getBoolean(INFO_KEY);
    }

    static {
        try {
            log4jUrl = Thread.currentThread().getContextClassLoader().getResource(LOG4J_CONF);
            if (log4jUrl == null) {
                log4jUrl = Thread.currentThread().getContextClassLoader().getResource(DEFAULT_CONF);
                isUsingDefault = true;
            }
            try {
                Class.forName("net.sf.infrared.org.apache.log4j.LogManager");
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            DOMConfigurator.configure(log4jUrl);
            isLoggingConfigured = true;
        }
        catch (RuntimeException ex) {
            System.out.println("[InfraRED] Problems configuring logging system");
            ex.printStackTrace();
        }
    }
}

