/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.base.util;

import java.io.Serializable;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.base.util.NodeVisitor;
import net.sf.infrared.base.util.TreeNode;
import net.sf.infrared.org.apache.log4j.Logger;

public class Tree
implements Serializable {
    private static final Logger log = LoggingFactory.getLogger(Tree.class);
    private TreeNode root = null;

    public Tree() {
        this.root = null;
    }

    public Tree(TreeNode root) {
        this.setRoot(root);
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public void setRoot(TreeNode root) {
        if (this.root != null) {
            this.root.setDepth(-1);
            this.root.setPostion(-1);
            if (log.isDebugEnabled()) {
                log.debug("Replacing root node of tree");
            }
        }
        this.root = root;
        if (this.root != null) {
            this.root.setDepth(0);
            this.root.setPostion(0);
        }
    }

    public void setDepth() {
        this.root.setDepth(0);
    }

    public void traverseBreadthFirst(NodeVisitor visitor) {
        if (log.isDebugEnabled()) {
            log.debug("Entering method traverseBreadthFirst");
        }
        visitor.beginTraversal();
        if (this.root != null) {
            visitor.visit(this.root);
            visitor.goingDown();
            this.root.traverseBreadthFirst(visitor);
            visitor.climbingUp();
        }
        visitor.endTraversal();
    }

    public TreeNode find(Object value) {
        if (this.root == null) {
            return null;
        }
        if (this.root.getValue() == value) {
            return this.root;
        }
        return this.root.find(value);
    }

    public String toString() {
        return this.root.toString();
    }
}

