/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.base.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.infrared.base.model.AggregateExecutionTime;
import net.sf.infrared.base.util.LoggingFactory;
import net.sf.infrared.base.util.Merger;
import net.sf.infrared.base.util.NodeVisitor;
import net.sf.infrared.org.apache.log4j.Logger;

public class TreeNode
implements Serializable,
Cloneable {
    private static final Logger log = LoggingFactory.getLogger(TreeNode.class);
    private Object value = null;
    private TreeNode parentNode = null;
    private List childNodes = new ArrayList();
    private int depth = -1;
    private int position = -1;

    public TreeNode() {
    }

    private TreeNode(Object value) {
        this.value = value;
    }

    public static TreeNode createTreeNode(Object value) {
        return new TreeNode(value);
    }

    public Object getValue() {
        return this.value;
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.childNodes);
    }

    public void addChild(TreeNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Child node can't be null");
        }
        if (child.getParent() != null) {
            throw new IllegalArgumentException("Child node is already a part of some node");
        }
        this.childNodes.add(child);
        child.setParent(this);
        if (this.depth != -1) {
            child.setDepth(this.depth + 1);
        }
        child.setPostion(this.childNodes.size() - 1);
    }

    public boolean removeChild(TreeNode child) {
        if (child == null) {
            throw new IllegalArgumentException("childnode can't be null");
        }
        int index = this.childNodes.indexOf(child);
        if (index == -1) {
            log.error("Child " + child + "not found in the list of children for node " + this);
            return false;
        }
        this.childNodes.remove(index);
        child.setParent(null);
        child.setDepth(-1);
        child.setPostion(-1);
        this.adjustPosition(index);
        return true;
    }

    private void adjustPosition(int index) {
        if (index < this.childNodes.size()) {
            ListIterator itr = this.childNodes.listIterator();
            while (itr.hasNext()) {
                TreeNode node = (TreeNode)itr.next();
                node.setPostion(node.getPosition() - 1);
            }
        }
    }

    public void setParent(TreeNode parentNode) {
        this.parentNode = parentNode;
    }

    public TreeNode getParent() {
        return this.parentNode;
    }

    public void traverseBreadthFirst(NodeVisitor visitor) {
        Iterator itr = this.childNodes.iterator();
        while (itr.hasNext()) {
            visitor.visit((TreeNode)itr.next());
        }
        if (this.childNodes.size() > 0) {
            visitor.goingDown();
            itr = this.childNodes.iterator();
            while (itr.hasNext()) {
                ((TreeNode)itr.next()).traverseBreadthFirst(visitor);
            }
            visitor.climbingUp();
        }
    }

    public TreeNode find(Object value) {
        Iterator itr = this.childNodes.iterator();
        while (itr.hasNext()) {
            TreeNode currNode = (TreeNode)itr.next();
            if (currNode.getValue().equals(value)) {
                return currNode;
            }
            TreeNode foundNode = currNode.find(value);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getPosition() {
        return this.position;
    }

    public void setDepth(int depth) {
        this.depth = depth;
        Iterator itr = this.childNodes.iterator();
        while (itr.hasNext()) {
            TreeNode childNode = (TreeNode)itr.next();
            if (depth != -1) {
                childNode.setDepth(depth + 1);
                continue;
            }
            childNode.setDepth(-1);
        }
    }

    void setPostion(int position) {
        this.position = position;
    }

    public void addChildren(List children) {
        this.childNodes.addAll(children);
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.getDepth(); ++i) {
            str = str + "--";
        }
        str = str + this.getValue().toString();
        Iterator iterator = this.childNodes.iterator();
        while (iterator.hasNext()) {
            str = str + "\n";
            TreeNode treeNode = (TreeNode)iterator.next();
            str = str + treeNode.toString();
        }
        return str;
    }

    public Object clone() {
        TreeNode clone = new TreeNode();
        clone.setDepth(this.depth);
        clone.setPostion(this.position);
        if (this.getValue() != null && this.getValue() instanceof AggregateExecutionTime) {
            clone.setValue(((AggregateExecutionTime)this.getValue()).clone());
        } else {
            clone.setValue(this.getValue());
        }
        List children = this.getChildren();
        if (children != null && children.size() > 0) {
            Iterator itr = children.iterator();
            while (itr.hasNext()) {
                TreeNode child = (TreeNode)itr.next();
                clone.addChild((TreeNode)child.clone());
            }
        }
        return clone;
    }

    public void mergeAsChild(TreeNode node, Merger merger) {
        TreeNode nodeToMergeOnto = null;
        Iterator i = this.childNodes.iterator();
        while (i.hasNext()) {
            TreeNode childNode = (TreeNode)i.next();
            if (!merger.isMatching(childNode, node)) continue;
            nodeToMergeOnto = childNode;
            break;
        }
        if (nodeToMergeOnto != null) {
            merger.mergeValue(nodeToMergeOnto, node);
        } else {
            nodeToMergeOnto = merger.createNewNode(node);
            this.addChild(nodeToMergeOnto);
        }
        i = node.childNodes.iterator();
        while (i.hasNext()) {
            TreeNode child = (TreeNode)i.next();
            nodeToMergeOnto.mergeAsChild(child, merger);
        }
    }

    void setValue(Object value) {
        this.value = value;
    }
}

