/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.org.apache.log4j;

import net.sf.infrared.org.apache.log4j.AsyncAppender;
import net.sf.infrared.org.apache.log4j.helpers.AppenderAttachableImpl;
import net.sf.infrared.org.apache.log4j.helpers.BoundedFIFO;
import net.sf.infrared.org.apache.log4j.helpers.LogLog;
import net.sf.infrared.org.apache.log4j.spi.LoggingEvent;

class Dispatcher
extends Thread {
    BoundedFIFO bf;
    AppenderAttachableImpl aai;
    boolean interrupted = false;
    AsyncAppender container;

    Dispatcher(BoundedFIFO bf, AsyncAppender container) {
        this.bf = bf;
        this.container = container;
        this.aai = container.aai;
        this.setDaemon(true);
        this.setPriority(1);
        this.setName("Dispatcher-" + this.getName());
    }

    void close() {
        BoundedFIFO boundedFIFO = this.bf;
        synchronized (boundedFIFO) {
            this.interrupted = true;
            if (this.bf.length() == 0) {
                this.bf.notify();
            }
        }
    }

    public void run() {
        while (true) {
            LoggingEvent event;
            BoundedFIFO boundedFIFO = this.bf;
            synchronized (boundedFIFO) {
                if (this.bf.length() == 0) {
                    if (this.interrupted) {
                        break;
                    }
                    try {
                        this.bf.wait();
                    }
                    catch (InterruptedException e) {
                        LogLog.error("The dispathcer should not be interrupted.");
                        break;
                    }
                }
                event = this.bf.get();
                if (this.bf.wasFull()) {
                    this.bf.notify();
                }
            }
            AppenderAttachableImpl appenderAttachableImpl = this.container.aai;
            synchronized (appenderAttachableImpl) {
                if (this.aai != null && event != null) {
                    this.aai.appendLoopOnAppenders(event);
                }
            }
        }
        this.aai.removeAllAppenders();
    }
}

