/*
 * Decompiled with CFR 0.152.
 */
package net.sf.infrared.org.apache.log4j;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import net.sf.infrared.org.apache.log4j.Hierarchy;
import net.sf.infrared.org.apache.log4j.Level;
import net.sf.infrared.org.apache.log4j.Logger;
import net.sf.infrared.org.apache.log4j.helpers.Loader;
import net.sf.infrared.org.apache.log4j.helpers.LogLog;
import net.sf.infrared.org.apache.log4j.helpers.OptionConverter;
import net.sf.infrared.org.apache.log4j.spi.DefaultRepositorySelector;
import net.sf.infrared.org.apache.log4j.spi.LoggerFactory;
import net.sf.infrared.org.apache.log4j.spi.LoggerRepository;
import net.sf.infrared.org.apache.log4j.spi.RepositorySelector;
import net.sf.infrared.org.apache.log4j.spi.RootLogger;

public class LogManager {
    public static final String DEFAULT_CONFIGURATION_FILE = "infrared-log4j.properties";
    static final String DEFAULT_XML_CONFIGURATION_FILE = "infrared-log4j.xml";
    public static final String DEFAULT_CONFIGURATION_KEY = "log4j.configuration";
    public static final String CONFIGURATOR_CLASS_KEY = "log4j.configuratorClass";
    public static final String DEFAULT_INIT_OVERRIDE_KEY = "log4j.defaultInitOverride";
    private static Object guard = null;
    private static RepositorySelector repositorySelector;

    public static void setRepositorySelector(RepositorySelector selector, Object guard) throws IllegalArgumentException {
        if (LogManager.guard != null && LogManager.guard != guard) {
            throw new IllegalArgumentException("Attempted to reset the LoggerFactory without possessing the guard.");
        }
        if (selector == null) {
            throw new IllegalArgumentException("RepositorySelector must be non-null.");
        }
        LogManager.guard = guard;
        repositorySelector = selector;
    }

    public static LoggerRepository getLoggerRepository() {
        return repositorySelector.getLoggerRepository();
    }

    public static Logger getRootLogger() {
        return repositorySelector.getLoggerRepository().getRootLogger();
    }

    public static Logger getLogger(String name) {
        return repositorySelector.getLoggerRepository().getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return repositorySelector.getLoggerRepository().getLogger(clazz.getName());
    }

    public static Logger getLogger(String name, LoggerFactory factory) {
        return repositorySelector.getLoggerRepository().getLogger(name, factory);
    }

    public static Logger exists(String name) {
        return repositorySelector.getLoggerRepository().exists(name);
    }

    public static Enumeration getCurrentLoggers() {
        return repositorySelector.getLoggerRepository().getCurrentLoggers();
    }

    public static void shutdown() {
        repositorySelector.getLoggerRepository().shutdown();
    }

    public static void resetConfiguration() {
        repositorySelector.getLoggerRepository().resetConfiguration();
    }

    static {
        Hierarchy h = new Hierarchy(new RootLogger(Level.DEBUG));
        repositorySelector = new DefaultRepositorySelector(h);
        String override = OptionConverter.getSystemProperty(DEFAULT_INIT_OVERRIDE_KEY, null);
        if (override == null || "false".equalsIgnoreCase(override)) {
            String configurationOptionStr = OptionConverter.getSystemProperty(DEFAULT_CONFIGURATION_KEY, null);
            String configuratorClassName = OptionConverter.getSystemProperty(CONFIGURATOR_CLASS_KEY, null);
            URL url = null;
            if (configurationOptionStr == null) {
                url = Loader.getResource(DEFAULT_XML_CONFIGURATION_FILE);
                if (url == null) {
                    url = Loader.getResource(DEFAULT_CONFIGURATION_FILE);
                }
            } else {
                try {
                    url = new URL(configurationOptionStr);
                }
                catch (MalformedURLException ex) {
                    url = Loader.getResource(configurationOptionStr);
                }
            }
            if (url != null) {
                LogLog.debug("Using URL [" + url + "] for automatic log4j configuration.");
                OptionConverter.selectAndConfigure(url, configuratorClassName, LogManager.getLoggerRepository());
            } else {
                LogLog.debug("Could not find resource: [" + configurationOptionStr + "].");
            }
        }
    }
}

