/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.service;

import org.springframework.binding.convert.ConversionExecutionException;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.converters.TwoWayConverter;

class TwoWayCapableConversionExecutor
implements ConversionExecutor {
    private Class sourceClass;
    private Class targetClass;
    private TwoWayConverter converter;

    public TwoWayCapableConversionExecutor(Class sourceClass, Class targetClass, TwoWayConverter converter) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.converter = converter;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public Object execute(Object source) throws ConversionExecutionException {
        if (source == null || this.converter.getSourceClass().isInstance(source)) {
            try {
                return this.converter.convertSourceToTargetClass(source, this.targetClass);
            }
            catch (Exception e) {
                throw new ConversionExecutionException(source, this.getSourceClass(), this.getTargetClass(), e);
            }
        }
        if (this.converter.getTargetClass().isInstance(source)) {
            try {
                return this.converter.convertTargetToSourceClass(source, this.sourceClass);
            }
            catch (Exception e) {
                throw new ConversionExecutionException(source, this.converter.getTargetClass(), this.getSourceClass(), e);
            }
        }
        throw new ConversionExecutionException(source, this.getSourceClass(), this.getTargetClass(), "Source object " + source + " to convert is expected to be an instance of [" + this.converter.getSourceClass().getName() + "] or [" + this.converter.getTargetClass().getName() + "]");
    }
}

