/*
 * Decompiled with CFR 0.152.
 */
package com.x.web.tiles2;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.TilesException;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.context.AbstractTilesApplicationContextFactory;
import org.apache.tiles.evaluator.el.ELAttributeEvaluator;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;
import org.apache.tiles.servlet.context.wildcard.WildcardServletTilesApplicationContextFactory;
import org.apache.tiles.web.util.ServletContextAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.view.tiles2.SpringLocaleResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringTilesConfigurer
implements ServletContextAware,
InitializingBean,
DisposableBean {
    protected static final Logger logger = LoggerFactory.getLogger(SpringTilesConfigurer.class);
    private final Properties tilesPropertyMap = new Properties();
    private ServletContext servletContext;
    private TilesApplicationContext tilesContext;

    public SpringTilesConfigurer() {
        this.tilesPropertyMap.put("org.apache.tiles.context.AbstractTilesApplicationContextFactory", WildcardServletTilesApplicationContextFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.preparer.PreparerFactory", BasicPreparerFactory.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.locale.LocaleResolver", SpringLocaleResolver.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.evaluator.AttributeEvaluator", ELAttributeEvaluator.class.getName());
        this.tilesPropertyMap.put("org.apache.tiles.factory.TilesContainerFactory.MUTABLE", Boolean.toString(false));
    }

    public void setDefinitions(String[] definitions) {
        if (definitions != null) {
            String defs = StringUtils.arrayToCommaDelimitedString((Object[])definitions);
            logger.info("TilesConfigurer: adding definitions [{}]", (Object)defs);
            this.tilesPropertyMap.put("org.apache.tiles.definition.DefinitionsFactory.DEFINITIONS_CONFIG", defs);
        }
    }

    public void setValidateDefinitions(boolean validateDefinitions) {
        this.tilesPropertyMap.put("org.apache.tiles.definition.digester.DigesterDefinitionsReader.PARSER_VALIDATE", Boolean.toString(validateDefinitions));
    }

    public void setDefinitionsFactoryClass(Class<?> definitionsFactoryClass) {
        this.tilesPropertyMap.put("org.apache.tiles.definition.DefinitionsFactory", definitionsFactoryClass.getName());
    }

    public void setPreparerFactoryClass(Class<?> preparerFactoryClass) {
        this.tilesPropertyMap.put("org.apache.tiles.preparer.PreparerFactory", preparerFactoryClass.getName());
    }

    public void setUseMutableTilesContainer(boolean useMutableTilesContainer) {
        this.tilesPropertyMap.put("org.apache.tiles.factory.TilesContainerFactory.MUTABLE", Boolean.toString(useMutableTilesContainer));
    }

    public void setTilesProperties(Properties tilesProperties) {
        CollectionUtils.mergePropertiesIntoMap((Properties)tilesProperties, (Map)this.tilesPropertyMap);
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void afterPropertiesSet() throws TilesException {
        TilesContainer container = this.createTilesContainer();
        TilesAccess.setContainer((TilesApplicationContext)this.tilesContext, (TilesContainer)container);
    }

    protected TilesContainer createTilesContainer() throws TilesException {
        ServletContextAdapter adaptedContext = new ServletContextAdapter((ServletConfig)new DelegatingServletConfig());
        ServletTilesApplicationContext preliminaryContext = new ServletTilesApplicationContext((ServletContext)adaptedContext);
        AbstractTilesApplicationContextFactory contextFactory = AbstractTilesApplicationContextFactory.createFactory((TilesApplicationContext)preliminaryContext);
        this.tilesContext = contextFactory.createApplicationContext((Object)adaptedContext);
        AbstractTilesContainerFactory factory = AbstractTilesContainerFactory.getTilesContainerFactory((TilesApplicationContext)this.tilesContext);
        return factory.createContainer(this.tilesContext);
    }

    public void destroy() throws TilesException {
        TilesAccess.setContainer((TilesApplicationContext)this.tilesContext, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getServletName() {
            return "TilesConfigurer";
        }

        public ServletContext getServletContext() {
            return SpringTilesConfigurer.this.servletContext;
        }

        public String getInitParameter(String paramName) {
            return SpringTilesConfigurer.this.tilesPropertyMap.getProperty(paramName);
        }

        public Enumeration<?> getInitParameterNames() {
            return SpringTilesConfigurer.this.tilesPropertyMap.keys();
        }
    }
}

