/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.web.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFilterImpl
implements Filter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ServletContext servletContext;

    public void destroy() {
        this.logger.debug("destroy()");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.logger.debug("init()");
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestURI = httpServletRequest.getRequestURI();
        this.logger.debug("request uri: {}", (Object)requestURI);
        this.preprocessFilterChain(request, response);
        filterChain.doFilter(request, response);
        this.postprocessFilterChain(request, response);
    }

    public abstract void preprocessFilterChain(ServletRequest var1, ServletResponse var2) throws IOException, ServletException;

    public abstract void postprocessFilterChain(ServletRequest var1, ServletResponse var2) throws IOException, ServletException;
}

