/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.web.filters;

import java.io.IOException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.codelabor.system.web.filters.BaseFilterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingFilter
extends BaseFilterImpl {
    private final Logger logger = LoggerFactory.getLogger(EncodingFilter.class);
    protected String encoding = "UTF-8";

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String tempEncoding = filterConfig.getInitParameter("encoding");
        if (!StringUtils.isEmpty((String)tempEncoding)) {
            this.encoding = tempEncoding;
        }
    }

    public void postprocessFilterChain(ServletRequest request, ServletResponse response) throws IOException, ServletException {
    }

    public void preprocessFilterChain(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        String requestBeforeEncoding = request.getCharacterEncoding();
        String responseBeforeEncoding = response.getCharacterEncoding();
        if (this.encoding.equalsIgnoreCase(requestBeforeEncoding)) {
            this.logger.debug("request character encoding: {}", (Object)this.encoding);
        } else {
            request.setCharacterEncoding(this.encoding);
            String requestAfterEncoding = request.getCharacterEncoding();
            this.logger.debug("request character encoding: {} -> {}", (Object)requestBeforeEncoding, (Object)requestAfterEncoding);
        }
        if (this.encoding.equalsIgnoreCase(responseBeforeEncoding)) {
            this.logger.debug("response character encoding: {}", (Object)this.encoding);
        } else {
            response.setCharacterEncoding(this.encoding);
            String responseAfterCharacterEncoding = response.getCharacterEncoding();
            this.logger.debug("response character encoding: {} -> {}", (Object)responseBeforeEncoding, (Object)responseAfterCharacterEncoding);
        }
    }
}

