/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.web.filters;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.codelabor.system.web.filters.NoCacheFilter;
import org.codelabor.system.web.filters.SelectiveFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SelectiveNoCacheFilter
extends NoCacheFilter
implements SelectiveFilter {
    private final Logger logger = LoggerFactory.getLogger(SelectiveNoCacheFilter.class);
    protected List<String> excludePatterns = null;
    protected List<String> includePatterns = null;
    protected String delimeterPattern = "([ ]*[,; ][ ]*)";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.includePatterns = this.getIncludePatterns(filterConfig);
        this.excludePatterns = this.getExcludePatterns(filterConfig);
    }

    @Override
    public List<String> getExcludePatterns(FilterConfig filterConfig) {
        String[] excludePatternsString;
        String tempExcludePattern = filterConfig.getInitParameter("excludes");
        List<String> excludePatterns = null;
        if (!StringUtils.isBlank((String)tempExcludePattern) && (excludePatternsString = tempExcludePattern.split(this.delimeterPattern)) != null && excludePatternsString.length > 0) {
            excludePatterns = Arrays.asList(excludePatternsString);
        }
        this.logger.debug("excludePatterns: {}", excludePatterns);
        return excludePatterns;
    }

    @Override
    public List<String> getIncludePatterns(FilterConfig filterConfig) {
        String[] includePatternsString;
        String tempIncludePattern = filterConfig.getInitParameter("includes");
        List<String> includePatterns = null;
        if (!StringUtils.isBlank((String)tempIncludePattern) && (includePatternsString = tempIncludePattern.split(this.delimeterPattern)) != null && includePatternsString.length > 0) {
            includePatterns = Arrays.asList(includePatternsString);
        }
        this.logger.debug("includePatterns: {}", includePatterns);
        return includePatterns;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String requestURI = httpServletRequest.getRequestURI();
        this.logger.debug("requestURI: {}", (Object)requestURI);
        if (this.isFilterRequired(requestURI)) {
            this.preprocessFilterChain(request, response);
        }
        filterChain.doFilter(request, response);
        if (this.isFilterRequired(requestURI)) {
            this.postprocessFilterChain(request, response);
        }
    }
}

