/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.web.json.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONHttpSessionServlet
extends HttpServlet {
    private static final long serialVersionUID = 5498874994938492455L;
    private final Logger logger = LoggerFactory.getLogger(JSONHttpSessionServlet.class);
    protected String encoding = "UTF-8";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession httpSession = request.getSession();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationTime", httpSession.getCreationTime());
        map.put("id", httpSession.getId());
        map.put("lastAccessedTime", httpSession.getLastAccessedTime());
        map.put("maxInactiveInterval", httpSession.getMaxInactiveInterval());
        map.put("hashCode", httpSession.hashCode());
        map.put("new", httpSession.isNew());
        this.logger.debug("map: {}", map);
        JSONObject jsonObject = JSONObject.fromObject(map);
        this.logger.debug("jsonObject: {}", (Object)jsonObject);
        response.setCharacterEncoding(this.encoding);
        PrintWriter printWriter = response.getWriter();
        printWriter.write(jsonObject.toString());
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String tempEncoding = config.getInitParameter("encoding");
        if (!StringUtils.isEmpty((String)tempEncoding)) {
            this.encoding = tempEncoding;
        }
    }
}

