/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.web.spring.webflow.handlers;

import java.io.IOException;
import org.codelabor.system.anyframe.exceptions.CommonException;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.webflow.definition.StateDefinition;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.RequestContext;

public class CommonExceptionHandler
implements FlowExecutionExceptionHandler {
    public boolean canHandle(FlowExecutionException exception) {
        return this.findBusinessException(exception) != null;
    }

    public void handle(FlowExecutionException exception, RequestControlContext requestControlContext) {
        requestControlContext.getMessageContext().addMessage(new MessageBuilder().error().source(null).defaultText(this.findBusinessException(exception).getMessage()).build());
        StateDefinition testState = requestControlContext.getCurrentState();
        if (testState instanceof ViewState) {
            ViewState viewState = (ViewState)testState;
            try {
                viewState.getViewFactory().getView((RequestContext)requestControlContext).render();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private CommonException findBusinessException(FlowExecutionException ex) {
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof CommonException)) continue;
            return (CommonException)cause;
        }
        return null;
    }
}

