/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.web.struts.handlers;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.util.ModuleException;
import org.codelabor.system.anyframe.exceptions.CommonException;
import org.codelabor.system.web.struts.handlers.BaseExceptionHandler;

public class CommonExceptionHandler
extends BaseExceptionHandler {
    public ActionForward execute(Exception ex, ExceptionConfig ae, ActionMapping mapping, ActionForm formInstance, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String property;
        ActionMessage error;
        this.logger.debug("ExceptionHandler executing for exception: {}", (Throwable)ex);
        ActionForward forward = ae.getPath() != null ? new ActionForward(ae.getPath()) : mapping.getInputForward();
        if (ex instanceof ModuleException) {
            error = ((ModuleException)ex).getActionMessage();
            property = ((ModuleException)ex).getProperty();
        } else {
            if (ex instanceof CommonException) {
                CommonException commonException = (CommonException)ex;
                request.setAttribute("org.codelabor.system.exceptions.COMMON_EXCEPTION", (Object)commonException);
            }
            error = new ActionMessage(ae.getKey(), (Object)ex.getMessage());
            property = error.getKey();
        }
        this.logException(ex);
        if (this.logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("-------------------------------");
            stringBuilder.append(System.getProperty("line.separator"));
            stringBuilder.append("StackTrace");
            stringBuilder.append(System.getProperty("line.separator"));
            this.logger.debug(stringBuilder.toString());
            Throwable throwable = ex;
            int i = 0;
            while (throwable != null) {
                StackTraceElement[] stackTraceList = throwable.getStackTrace();
                int count = stackTraceList.length;
                stringBuilder = new StringBuilder();
                stringBuilder.append(System.getProperty("line.separator"));
                stringBuilder.append(System.getProperty("line.separator"));
                int j = count - 1;
                int k = 0;
                while (j >= 0) {
                    stringBuilder.append("StackTraceElement[");
                    stringBuilder.append(j).append("]: ");
                    stringBuilder.append(stackTraceList[j].toString());
                    stringBuilder.append(System.getProperty("line.separator"));
                    --j;
                    ++k;
                }
                this.logger.debug(stringBuilder.toString());
                throwable = throwable.getCause();
                ++i;
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("-------------------------------");
            this.logger.debug(stringBuilder.toString());
        }
        request.setAttribute("org.apache.struts.action.EXCEPTION", (Object)ex);
        this.storeException(request, property, error, forward, ae.getScope());
        if (!response.isCommitted()) {
            return forward;
        }
        this.logger.debug("Response is already committed, so forwarding will not work. Attempt alternate handling.");
        if (!this.silent(ae)) {
            this.handleCommittedResponse(ex, ae, mapping, formInstance, request, response, forward);
        } else {
            this.logger.warn("ExceptionHandler configured with {}s and response is committed.", (Object)"SILENT_IF_COMMITTED");
        }
        return null;
    }

    private boolean silent(ExceptionConfig config) {
        return "true".equals(config.getProperty("SILENT_IF_COMMITTED"));
    }
}

