/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.web.utils;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codelabor.system.utils.FileUtils;
import org.codelabor.system.utils.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIPatternMatcherUtils {
    private static Logger logger = LoggerFactory.getLogger(URIPatternMatcherUtils.class);

    public static boolean matchByAntStylePathPattern(List<String> includePatterns, List<String> excludePatterns, String requestURI) {
        boolean isMatched = false;
        if (excludePatterns != null) {
            if (!ListUtils.containsByAntStylePattern(excludePatterns, (String)requestURI)) {
                isMatched = includePatterns != null ? ListUtils.containsByAntStylePattern(includePatterns, (String)requestURI) : true;
            }
        } else {
            isMatched = includePatterns != null ? ListUtils.containsByAntStylePattern(includePatterns, (String)requestURI) : true;
        }
        logger.debug("isMatched: {}", (Object)isMatched);
        return isMatched;
    }

    public static boolean matchByURI(List<String> includePatterns, List<String> excludePatterns, String requestURI) {
        boolean isMatched = false;
        if (excludePatterns != null) {
            if (!excludePatterns.contains(requestURI)) {
                isMatched = includePatterns != null ? includePatterns.contains(requestURI) : true;
            }
        } else {
            isMatched = includePatterns != null ? includePatterns.contains(requestURI) : true;
        }
        logger.debug("isMatched: {}", (Object)isMatched);
        return isMatched;
    }

    public static boolean matchByExtension(List<String> includePatterns, List<String> excludePatterns, String requestURI) {
        boolean isMatched = false;
        String extension = FileUtils.getExtension((String)requestURI);
        if (!StringUtils.isBlank((String)extension)) {
            extension = extension.toLowerCase();
        }
        logger.debug("extension: {}", (Object)extension);
        if (excludePatterns != null) {
            if (!excludePatterns.contains(extension)) {
                isMatched = includePatterns != null ? includePatterns.contains(extension) : true;
            }
        } else {
            isMatched = includePatterns != null ? includePatterns.contains(extension) : true;
        }
        logger.debug("isMatched: {}", (Object)isMatched);
        return isMatched;
    }
}

