/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.aspectj.weaver.AnnotatedElement;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.JoinPointSignatureIterator;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;

public class MemberImpl
implements Comparable,
AnnotatedElement,
Member {
    protected Member.Kind kind;
    protected UnresolvedType declaringType;
    protected int modifiers;
    protected UnresolvedType returnType;
    protected String name;
    protected UnresolvedType[] parameterTypes;
    private final String signature;
    private String paramSignature;
    private boolean reportedCantFindDeclaringType = false;
    private boolean reportedUnresolvableMember = false;
    private JoinPointSignatureIterator joinPointSignatures = null;
    private static final String[] ZERO_STRINGS = new String[0];
    private volatile int hashCode = 0;

    public MemberImpl(Member.Kind kind, UnresolvedType declaringType, int modifiers, String name, String signature) {
        this.kind = kind;
        this.declaringType = declaringType;
        this.modifiers = modifiers;
        this.name = name;
        this.signature = signature;
        if (kind == Member.FIELD) {
            this.returnType = UnresolvedType.forSignature(signature);
            this.parameterTypes = UnresolvedType.NONE;
        } else {
            Object[] returnAndParams = MemberImpl.signatureToTypes(signature, false);
            this.returnType = (UnresolvedType)returnAndParams[0];
            this.parameterTypes = (UnresolvedType[])returnAndParams[1];
        }
    }

    public MemberImpl(Member.Kind kind, UnresolvedType declaringType, int modifiers, UnresolvedType returnType, String name, UnresolvedType[] parameterTypes) {
        this.kind = kind;
        this.declaringType = declaringType;
        this.modifiers = modifiers;
        this.returnType = returnType;
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.signature = kind == Member.FIELD ? returnType.getErasureSignature() : MemberImpl.typesToSignature(returnType, parameterTypes, true);
    }

    public ResolvedMember resolve(World world) {
        return world.resolve(this);
    }

    public static String typesToSignature(UnresolvedType returnType, UnresolvedType[] paramTypes, boolean useRawTypes) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int len = paramTypes.length;
        for (int i = 0; i < len; ++i) {
            if (paramTypes[i].isParameterizedType() && useRawTypes) {
                buf.append(paramTypes[i].getErasureSignature());
                continue;
            }
            if (paramTypes[i].isTypeVariableReference() && useRawTypes) {
                buf.append(paramTypes[i].getErasureSignature());
                continue;
            }
            buf.append(paramTypes[i].getSignature());
        }
        buf.append(")");
        if (returnType.isParameterizedType() && useRawTypes) {
            buf.append(returnType.getErasureSignature());
        } else if (returnType.isTypeVariableReference() && useRawTypes) {
            buf.append(returnType.getErasureSignature());
        } else {
            buf.append(returnType.getSignature());
        }
        return buf.toString();
    }

    public static String typesToSignature(UnresolvedType[] paramTypes) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            buf.append(paramTypes[i].getSignature());
        }
        buf.append(")");
        return buf.toString();
    }

    private static Object[] signatureToTypes(String sig, boolean keepParameterizationInfo) {
        char c;
        boolean hasAnyAnglies;
        ArrayList<UnresolvedType> l = new ArrayList<UnresolvedType>();
        int i = 1;
        boolean bl = hasAnyAnglies = sig.indexOf(60) != -1;
        while ((c = sig.charAt(i)) != ')') {
            int nextSemicolon;
            int start = i;
            while (c == '[') {
                c = sig.charAt(++i);
            }
            if (c == 'L' || c == 'P') {
                int firstAngly;
                nextSemicolon = sig.indexOf(59, start);
                int n = firstAngly = hasAnyAnglies ? sig.indexOf(60, start) : -1;
                if (!hasAnyAnglies || firstAngly == -1 || firstAngly > nextSemicolon) {
                    i = nextSemicolon + 1;
                    l.add(UnresolvedType.forSignature(sig.substring(start, i)));
                    continue;
                }
                boolean endOfSigReached = false;
                int posn = firstAngly;
                int genericDepth = 0;
                while (!endOfSigReached) {
                    switch (sig.charAt(posn)) {
                        case '<': {
                            ++genericDepth;
                            break;
                        }
                        case '>': {
                            --genericDepth;
                            break;
                        }
                        case ';': {
                            if (genericDepth != 0) break;
                            endOfSigReached = true;
                            break;
                        }
                    }
                    ++posn;
                }
                i = posn;
                l.add(UnresolvedType.forSignature(sig.substring(start, i)));
                continue;
            }
            if (c == 'T') {
                nextSemicolon = sig.indexOf(59, start);
                String nextbit = sig.substring(start, nextSemicolon);
                l.add(UnresolvedType.forSignature(nextbit));
                i = nextSemicolon + 1;
                continue;
            }
            l.add(UnresolvedType.forSignature(sig.substring(start, ++i)));
        }
        UnresolvedType[] paramTypes = l.toArray(new UnresolvedType[l.size()]);
        UnresolvedType returnType = UnresolvedType.forSignature(sig.substring(i + 1, sig.length()));
        return new Object[]{returnType, paramTypes};
    }

    public static MemberImpl field(String declaring, int mods, String name, String signature) {
        return MemberImpl.field(declaring, mods, UnresolvedType.forSignature(signature), name);
    }

    public static Member field(UnresolvedType declaring, int mods, String name, UnresolvedType type) {
        return new MemberImpl(Member.FIELD, declaring, mods, type, name, UnresolvedType.NONE);
    }

    public static MemberImpl method(UnresolvedType declaring, int mods, String name, String signature) {
        Object[] pair = MemberImpl.signatureToTypes(signature, false);
        return MemberImpl.method(declaring, mods, (UnresolvedType)pair[0], name, (UnresolvedType[])pair[1]);
    }

    public static MemberImpl monitorEnter() {
        return new MemberImpl(Member.MONITORENTER, UnresolvedType.OBJECT, 8, ResolvedType.VOID, "<lock>", UnresolvedType.ARRAY_WITH_JUST_OBJECT);
    }

    public static MemberImpl monitorExit() {
        return new MemberImpl(Member.MONITOREXIT, UnresolvedType.OBJECT, 8, ResolvedType.VOID, "<unlock>", UnresolvedType.ARRAY_WITH_JUST_OBJECT);
    }

    public static Member pointcut(UnresolvedType declaring, String name, String signature) {
        Object[] pair = MemberImpl.signatureToTypes(signature, false);
        return MemberImpl.pointcut(declaring, 0, (UnresolvedType)pair[0], name, (UnresolvedType[])pair[1]);
    }

    private static MemberImpl field(String declaring, int mods, UnresolvedType ty, String name) {
        return new MemberImpl(Member.FIELD, UnresolvedType.forName(declaring), mods, ty, name, UnresolvedType.NONE);
    }

    public static MemberImpl method(UnresolvedType declTy, int mods, UnresolvedType rTy, String name, UnresolvedType[] paramTys) {
        return new MemberImpl(name.equals("<init>") ? Member.CONSTRUCTOR : Member.METHOD, declTy, mods, rTy, name, paramTys);
    }

    private static Member pointcut(UnresolvedType declTy, int mods, UnresolvedType rTy, String name, UnresolvedType[] paramTys) {
        return new MemberImpl(Member.POINTCUT, declTy, mods, rTy, name, paramTys);
    }

    public static ResolvedMemberImpl makeExceptionHandlerSignature(UnresolvedType inType, UnresolvedType catchType) {
        return new ResolvedMemberImpl(Member.HANDLER, inType, 8, "<catch>", "(" + catchType.getSignature() + ")V");
    }

    public static MemberImpl fieldFromString(String str) {
        str = str.trim();
        int len = str.length();
        int i = 0;
        int mods = 0;
        if (str.startsWith("static", i)) {
            mods = 8;
            i += 6;
            while (Character.isWhitespace(str.charAt(i))) {
                ++i;
            }
        }
        int start = i;
        while (!Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        UnresolvedType retTy = UnresolvedType.forName(str.substring(start, i));
        start = i;
        i = str.lastIndexOf(46);
        UnresolvedType declaringTy = UnresolvedType.forName(str.substring(start, i).trim());
        start = ++i;
        String name = str.substring(start, len).trim();
        return new MemberImpl(Member.FIELD, declaringTy, mods, retTy, name, UnresolvedType.NONE);
    }

    public static Member methodFromString(String str) {
        str = str.trim();
        int i = 0;
        int mods = 0;
        if (str.startsWith("static", i)) {
            mods = 8;
            i += 6;
        } else if (str.startsWith("interface", i)) {
            mods = 512;
            i += 9;
        } else if (str.startsWith("private", i)) {
            mods = 2;
            i += 7;
        }
        while (Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        int start = i;
        while (!Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        UnresolvedType returnTy = UnresolvedType.forName(str.substring(start, i));
        start = i;
        i = str.indexOf(40, i);
        i = str.lastIndexOf(46, i);
        UnresolvedType declaringTy = UnresolvedType.forName(str.substring(start, i).trim());
        start = ++i;
        i = str.indexOf(40, i);
        String name = str.substring(start, i).trim();
        start = ++i;
        i = str.indexOf(41, i);
        String[] paramTypeNames = MemberImpl.parseIds(str.substring(start, i).trim());
        return MemberImpl.method(declaringTy, mods, returnTy, name, UnresolvedType.forNames(paramTypeNames));
    }

    private static String[] parseIds(String str) {
        if (str.length() == 0) {
            return ZERO_STRINGS;
        }
        ArrayList<String> l = new ArrayList<String>();
        int start = 0;
        while (true) {
            int i;
            if ((i = str.indexOf(44, start)) == -1) break;
            l.add(str.substring(start, i).trim());
            start = i + 1;
        }
        l.add(str.substring(start).trim());
        return l.toArray(new String[l.size()]);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Member)) {
            return false;
        }
        Member o = (Member)other;
        return this.getKind() == o.getKind() && this.getName().equals(o.getName()) && this.getSignature().equals(o.getSignature()) && this.getDeclaringType().equals(o.getDeclaringType());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getKind().hashCode();
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + this.getSignature().hashCode();
            this.hashCode = result = 37 * result + this.getDeclaringType().hashCode();
        }
        return this.hashCode;
    }

    public int compareTo(Object other) {
        Member o = (Member)other;
        int i = this.getName().compareTo(o.getName());
        if (i != 0) {
            return i;
        }
        return this.getSignature().compareTo(o.getSignature());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.returnType.getName());
        buf.append(' ');
        buf.append(this.declaringType.getName());
        buf.append('.');
        buf.append(this.name);
        if (this.kind != Member.FIELD) {
            buf.append("(");
            if (this.parameterTypes.length != 0) {
                buf.append(this.parameterTypes[0]);
                int len = this.parameterTypes.length;
                for (int i = 1; i < len; ++i) {
                    buf.append(", ");
                    buf.append(this.parameterTypes[i].getName());
                }
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public String toLongString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.kind);
        buf.append(' ');
        if (this.modifiers != 0) {
            buf.append(Modifier.toString(this.modifiers));
            buf.append(' ');
        }
        buf.append(this.toString());
        buf.append(" <");
        buf.append(this.signature);
        buf.append(" >");
        return buf.toString();
    }

    public Member.Kind getKind() {
        return this.kind;
    }

    public UnresolvedType getDeclaringType() {
        return this.declaringType;
    }

    public UnresolvedType getReturnType() {
        return this.returnType;
    }

    public UnresolvedType getGenericReturnType() {
        return this.getReturnType();
    }

    public UnresolvedType[] getGenericParameterTypes() {
        return this.getParameterTypes();
    }

    public UnresolvedType getType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public UnresolvedType[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String getSignature() {
        return this.signature;
    }

    public int getArity() {
        return this.parameterTypes.length;
    }

    public String getParameterSignature() {
        if (this.paramSignature != null) {
            return this.paramSignature;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            UnresolvedType tx = this.parameterTypes[i];
            sb.append(tx.getSignature());
        }
        sb.append(")");
        this.paramSignature = sb.toString();
        return this.paramSignature;
    }

    public boolean isCompatibleWith(Member am) {
        if (this.kind != Member.METHOD || am.getKind() != Member.METHOD) {
            return true;
        }
        if (!this.name.equals(am.getName())) {
            return true;
        }
        if (!MemberImpl.equalTypes(this.getParameterTypes(), am.getParameterTypes())) {
            return true;
        }
        return this.getReturnType().equals(am.getReturnType());
    }

    private static boolean equalTypes(UnresolvedType[] a, UnresolvedType[] b) {
        int len = a.length;
        if (len != b.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    public int getModifiers(World world) {
        ResolvedMember resolved = this.resolve(world);
        if (resolved == null) {
            this.reportDidntFindMember(world);
            return 0;
        }
        return resolved.getModifiers();
    }

    public UnresolvedType[] getExceptions(World world) {
        ResolvedMember resolved = this.resolve(world);
        if (resolved == null) {
            this.reportDidntFindMember(world);
            return UnresolvedType.NONE;
        }
        return resolved.getExceptions();
    }

    public final boolean isProtected(World world) {
        return Modifier.isProtected(this.resolve(world).getModifiers());
    }

    public final boolean isStatic(World world) {
        return Modifier.isStatic(this.resolve(world).getModifiers());
    }

    public final boolean isStrict(World world) {
        return Modifier.isStrict(this.resolve(world).getModifiers());
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public final boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    public final boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean canBeParameterized() {
        return false;
    }

    public final int getCallsiteModifiers() {
        return this.modifiers & 0xFFFFFDFF;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public final String getExtractableName() {
        if (this.name.equals("<init>")) {
            return "init$";
        }
        if (this.name.equals("<clinit>")) {
            return "clinit$";
        }
        return this.name;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        throw new UnsupportedOperationException("You should resolve this member and call hasAnnotation() on the result...");
    }

    public ResolvedType[] getAnnotationTypes() {
        throw new UnsupportedOperationException("You should resolve this member and call hasAnnotation() on the result...");
    }

    public AnnotationX[] getAnnotations() {
        throw new UnsupportedOperationException("You should resolve this member '" + this + "' and call getAnnotations() on the result...");
    }

    public Collection getDeclaringTypes(World world) {
        ResolvedType myType = this.getDeclaringType().resolve(world);
        HashSet<ResolvedType> ret = new HashSet<ResolvedType>();
        if (this.kind == Member.CONSTRUCTOR) {
            ret.add(myType);
        } else if (this.isStatic() || this.kind == Member.FIELD) {
            this.walkUpStatic(ret, myType);
        } else {
            this.walkUp(ret, myType);
        }
        return ret;
    }

    private boolean walkUp(Collection acc, ResolvedType curr) {
        if (acc.contains(curr)) {
            return true;
        }
        boolean b = false;
        Iterator i = curr.getDirectSupertypes();
        while (i.hasNext()) {
            b |= this.walkUp(acc, (ResolvedType)i.next());
        }
        if (!b && curr.isParameterizedType()) {
            b = this.walkUp(acc, curr.getGenericType());
        }
        if (!b) {
            boolean bl = b = curr.lookupMemberNoSupers(this) != null;
        }
        if (b) {
            acc.add(curr);
        }
        return b;
    }

    private boolean walkUpStatic(Collection acc, ResolvedType curr) {
        if (curr.lookupMemberNoSupers(this) != null) {
            acc.add(curr);
            return true;
        }
        boolean b = false;
        Iterator i = curr.getDirectSupertypes();
        while (i.hasNext()) {
            b |= this.walkUpStatic(acc, (ResolvedType)i.next());
        }
        if (!b && curr.isParameterizedType()) {
            b = this.walkUpStatic(acc, curr.getGenericType());
        }
        if (b) {
            acc.add(curr);
        }
        return b;
    }

    public String getSignatureMakerName() {
        if (this.getName().equals("<clinit>")) {
            return "makeInitializerSig";
        }
        Member.Kind kind = this.getKind();
        if (kind == Member.METHOD) {
            return "makeMethodSig";
        }
        if (kind == Member.CONSTRUCTOR) {
            return "makeConstructorSig";
        }
        if (kind == Member.FIELD) {
            return "makeFieldSig";
        }
        if (kind == Member.HANDLER) {
            return "makeCatchClauseSig";
        }
        if (kind == Member.STATIC_INITIALIZATION) {
            return "makeInitializerSig";
        }
        if (kind == Member.ADVICE) {
            return "makeAdviceSig";
        }
        if (kind == Member.MONITORENTER) {
            return "makeLockSig";
        }
        if (kind == Member.MONITOREXIT) {
            return "makeUnlockSig";
        }
        throw new RuntimeException("unimplemented");
    }

    public String getSignatureType() {
        Member.Kind kind = this.getKind();
        if (this.getName().equals("<clinit>")) {
            return "org.aspectj.lang.reflect.InitializerSignature";
        }
        if (kind == Member.METHOD) {
            return "org.aspectj.lang.reflect.MethodSignature";
        }
        if (kind == Member.CONSTRUCTOR) {
            return "org.aspectj.lang.reflect.ConstructorSignature";
        }
        if (kind == Member.FIELD) {
            return "org.aspectj.lang.reflect.FieldSignature";
        }
        if (kind == Member.HANDLER) {
            return "org.aspectj.lang.reflect.CatchClauseSignature";
        }
        if (kind == Member.STATIC_INITIALIZATION) {
            return "org.aspectj.lang.reflect.InitializerSignature";
        }
        if (kind == Member.ADVICE) {
            return "org.aspectj.lang.reflect.AdviceSignature";
        }
        if (kind == Member.MONITORENTER) {
            return "org.aspectj.lang.reflect.LockSignature";
        }
        if (kind == Member.MONITOREXIT) {
            return "org.aspectj.lang.reflect.UnlockSignature";
        }
        throw new RuntimeException("unimplemented");
    }

    public String getSignatureString(World world) {
        if (this.getName().equals("<clinit>")) {
            return this.getStaticInitializationSignatureString(world);
        }
        Member.Kind kind = this.getKind();
        if (kind == Member.METHOD) {
            return this.getMethodSignatureString(world);
        }
        if (kind == Member.CONSTRUCTOR) {
            return this.getConstructorSignatureString(world);
        }
        if (kind == Member.FIELD) {
            return this.getFieldSignatureString(world);
        }
        if (kind == Member.HANDLER) {
            return this.getHandlerSignatureString(world);
        }
        if (kind == Member.STATIC_INITIALIZATION) {
            return this.getStaticInitializationSignatureString(world);
        }
        if (kind == Member.ADVICE) {
            return this.getAdviceSignatureString(world);
        }
        if (kind == Member.MONITORENTER || kind == Member.MONITOREXIT) {
            return this.getMonitorSignatureString(world);
        }
        throw new RuntimeException("unimplemented");
    }

    private String getHandlerSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(0));
        buf.append('-');
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterTypes()[0]));
        buf.append('-');
        String pName = "<missing>";
        String[] names = this.getParameterNames(world);
        if (names != null) {
            pName = names[0];
        }
        buf.append(pName);
        buf.append('-');
        return buf.toString();
    }

    private String getStaticInitializationSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(this.getModifiers(world)));
        buf.append('-');
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        return buf.toString();
    }

    protected String getAdviceSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(this.getModifiers(world)));
        buf.append('-');
        buf.append(this.getName());
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterTypes()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterNames(world)));
        buf.append('-');
        buf.append(this.makeString(this.getExceptions(world)));
        buf.append('-');
        buf.append(this.makeString(this.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected String getMethodSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(this.getModifiers(world)));
        buf.append('-');
        buf.append(this.getName());
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterTypes()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterNames(world)));
        buf.append('-');
        buf.append(this.makeString(this.getExceptions(world)));
        buf.append('-');
        buf.append(this.makeString(this.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected String getMonitorSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(8));
        buf.append('-');
        buf.append(this.getName());
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterTypes()[0]));
        buf.append('-');
        buf.append("");
        buf.append('-');
        return buf.toString();
    }

    protected String getConstructorSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(this.getModifiers(world)));
        buf.append('-');
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterTypes()));
        buf.append('-');
        buf.append(this.makeString(this.getParameterNames(world)));
        buf.append('-');
        buf.append(this.makeString(this.getExceptions(world)));
        buf.append('-');
        return buf.toString();
    }

    protected String getFieldSignatureString(World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.makeString(this.getModifiers(world)));
        buf.append('-');
        buf.append(this.getName());
        buf.append('-');
        buf.append(this.makeString(this.getDeclaringType()));
        buf.append('-');
        buf.append(this.makeString(this.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected String makeString(int i) {
        return Integer.toString(i, 16);
    }

    protected String makeString(UnresolvedType t) {
        if (t.isArray()) {
            return t.getSignature().replace('/', '.');
        }
        return t.getName();
    }

    protected String makeString(UnresolvedType[] types) {
        if (types == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            buf.append(this.makeString(types[i]));
            buf.append(':');
        }
        return buf.toString();
    }

    protected String makeString(String[] names) {
        if (names == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = names.length;
        for (int i = 0; i < len; ++i) {
            buf.append(names[i]);
            buf.append(':');
        }
        return buf.toString();
    }

    public String[] getParameterNames(World world) {
        ResolvedMember resolved = this.resolve(world);
        if (resolved == null) {
            this.reportDidntFindMember(world);
            return null;
        }
        return resolved.getParameterNames();
    }

    public Iterator getJoinPointSignatures(World inAWorld) {
        if (this.joinPointSignatures == null) {
            this.joinPointSignatures = new JoinPointSignatureIterator(this, inAWorld);
        }
        this.joinPointSignatures.reset();
        return this.joinPointSignatures;
    }

    private void reportDidntFindMember(World world) {
        if (this.reportedCantFindDeclaringType || this.reportedUnresolvableMember) {
            return;
        }
        ResolvedType rType = this.getDeclaringType().resolve(world);
        if (rType.isMissing()) {
            world.getLint().cantFindType.signal(WeaverMessages.format("cantFindType", rType.getName()), null);
            this.reportedCantFindDeclaringType = true;
        } else {
            world.getLint().unresolvableMember.signal(this.getName(), null);
            this.reportedUnresolvableMember = true;
        }
    }
}

