/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.sf.log4jdbc.ConnectionSpy;
import net.sf.log4jdbc.RdbmsSpecifics;
import net.sf.log4jdbc.SpyLogDelegator;
import net.sf.log4jdbc.SpyLogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnyframeDataSourceSpy
implements DataSource {
    private DataSource dataSource = null;
    static final SpyLogDelegator log = SpyLogFactory.getSpyLogDelegator();
    static RdbmsSpecifics defaultRdbmsSpecifics = new RdbmsSpecifics();

    @Override
    public Connection getConnection() throws SQLException {
        return this.getWrappedConnection(this.dataSource.getConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getWrappedConnection(this.dataSource.getConnection(username, password));
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    private Connection getWrappedConnection(Connection connection) {
        if (log.isJdbcLoggingEnabled()) {
            ConnectionSpy connectionSpy = new ConnectionSpy(connection);
            connectionSpy.setRdbmsSpecifics(defaultRdbmsSpecifics);
            return connectionSpy;
        }
        return connection;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

