/*
 * Decompiled with CFR 0.152.
 */
package org.codelabor.system.timer;

import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(Timer.class);
    protected final int intervalTime = 100;
    protected int elapsedTime = 0;
    protected int timeout = 60000;

    public Timer(int timeout) {
        this.timeout = timeout;
    }

    public synchronized void reset() {
        this.elapsedTime = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        super.run();
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                continue;
            }
            Timer timer = this;
            synchronized (timer) {
                this.elapsedTime += 100;
                if (this.elapsedTime > this.timeout) {
                    try {
                        this.timeout();
                    }
                    catch (TimeoutException e) {
                        this.logger.equals(e);
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void timeout() throws TimeoutException {
        StringBuilder sb = new StringBuilder();
        sb.append("time exceeded: ").append(this.timeout);
        throw new TimeoutException(sb.toString());
    }
}

