/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.cache.impl;

import com.opensymphony.oscache.base.Cache;
import com.opensymphony.oscache.base.Config;
import com.opensymphony.oscache.base.InitializationException;
import com.opensymphony.oscache.base.events.CacheEntryEvent;
import com.opensymphony.oscache.plugins.clustersupport.ClusterNotification;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSBroadcastingListener
extends com.opensymphony.oscache.plugins.clustersupport.JMSBroadcastingListener {
    Log log = LogFactory.getLog((Class)JMSBroadcastingListener.class);
    private static final int REMOVE_KEY = 10;
    private Config config = null;

    public void initialize(Cache cache, Config config) throws InitializationException {
        this.config = config;
        super.initialize(cache, config);
    }

    public void cacheEntryUpdated(CacheEntryEvent event) {
        if (!"NESTED".equals(event.getOrigin()) && !"CLUSTER".equals(event.getOrigin())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("cacheEntryFlushed called (" + event + ")"));
            }
            this.sendNotification(new ClusterNotification(10, (Serializable)((Object)event.getKey())));
        }
    }

    public void handleClusterNotification(ClusterNotification message) {
        if (this.cache == null) {
            this.log.warn((Object)("A cluster notification (" + message + ") was received, but no cache is registered on this machine. Notification ignored."));
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Cluster notification (" + message + ") was received."));
        }
        switch (message.getType()) {
            case 1: {
                this.cache.flushEntry((String)((Object)message.getData()), "CLUSTER");
                break;
            }
            case 2: {
                this.cache.flushGroup((String)((Object)message.getData()), "CLUSTER");
                break;
            }
            case 3: {
                this.cache.flushPattern((String)((Object)message.getData()), "CLUSTER");
                break;
            }
            case 4: {
                this.cache.flushAll((Date)message.getData(), "CLUSTER");
                break;
            }
            case 10: {
                this.cache.removeEntry((String)((Object)message.getData()));
                break;
            }
            default: {
                this.log.error((Object)("The cluster notification (" + message + ") is of an unknown type. Notification ignored."));
            }
        }
    }

    public InitialContext getInitialContext() throws NamingException {
        String url = this.config.getProperty("cache.cluster.jndi.cofig");
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jndi.properties");
        Properties prop = new Properties();
        try {
            prop.load(in);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new InitialContext(prop);
    }
}

