/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.idgen.impl;

import anyframe.common.exception.BaseException;
import anyframe.core.idgen.impl.AbstractDataSourceIdGenerationService;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractDataSourceBlockIdGenerationService
extends AbstractDataSourceIdGenerationService
implements InitializingBean {
    private BigDecimal mFirstBigDecimal;
    private long mFirstLong;
    private int mBlockSize;
    private int mAllocated;

    protected abstract BigDecimal allocateBigDecimalIdBlock(int var1) throws BaseException;

    protected abstract long allocateLongIdBlock(int var1) throws BaseException;

    protected BigDecimal getNextBigDecimalIdInner() throws BaseException {
        if (this.mAllocated >= this.mBlockSize) {
            try {
                this.mFirstBigDecimal = this.allocateBigDecimalIdBlock(this.mBlockSize);
                this.mAllocated = 0;
            }
            catch (BaseException be) {
                this.mAllocated = Integer.MAX_VALUE;
                throw be;
            }
        }
        BigDecimal id = this.mFirstBigDecimal.add(new BigDecimal(new Integer(this.mAllocated).doubleValue()));
        ++this.mAllocated;
        return id;
    }

    protected long getNextLongIdInner() throws BaseException {
        long id;
        if (this.mAllocated >= this.mBlockSize) {
            try {
                this.mFirstLong = this.allocateLongIdBlock(this.mBlockSize);
                this.mAllocated = 0;
            }
            catch (BaseException e) {
                this.mAllocated = Integer.MAX_VALUE;
                throw e;
            }
        }
        if ((id = this.mFirstLong + (long)this.mAllocated) < 0L) {
            this.getLogger().error((Object)this.messageSource.getMessage("error.idgen.greater.maxid", (Object[])new String[]{"Long"}, Locale.getDefault()));
            throw new BaseException(this.messageSource, "error.idgen.greater.maxid");
        }
        ++this.mAllocated;
        return id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.mBlockSize = configuration.getAttributeAsInteger("block-size", 0);
        if (this.mBlockSize == 0) {
            this.mBlockSize = configuration.getChild("block-size").getValueAsInteger(10);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.mAllocated = Integer.MAX_VALUE;
    }
}

