/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.idgen.impl;

import anyframe.common.exception.BaseException;
import anyframe.core.idgen.IIdGenerationService;
import anyframe.core.idgen.IdGenerationStrategy;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;

public abstract class AbstractIdGenerationService
implements IIdGenerationService,
ApplicationContextAware,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private static final BigDecimal BIG_DECIMAL_MAX_LONG = new BigDecimal(new Long(Long.MAX_VALUE).doubleValue());
    private Object mSemaphore = new Object();
    private IdGenerationStrategy strategy = new IdGenerationStrategy(){

        public String makeId(String originalId) {
            return originalId;
        }
    };
    private boolean mUseBigDecimals;
    protected MessageSource messageSource;

    protected Log getLogger() {
        return IIdGenerationService.LOGGER;
    }

    protected abstract BigDecimal getNextBigDecimalIdInner() throws BaseException;

    protected abstract long getNextLongIdInner() throws BaseException;

    protected final void setUseBigDecimals(boolean useBigDecimals) {
        this.mUseBigDecimals = useBigDecimals;
    }

    protected final boolean isUsingBigDecimals() {
        return this.mUseBigDecimals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getNextLongIdChecked(long maxId) throws BaseException {
        long nextId;
        if (this.mUseBigDecimals) {
            BigDecimal bd;
            Object object = this.mSemaphore;
            synchronized (object) {
                bd = this.getNextBigDecimalIdInner();
            }
            if (bd.compareTo(BIG_DECIMAL_MAX_LONG) > 0) {
                this.getLogger().error((Object)this.messageSource.getMessage("error.idgen.greater.maxid", (Object[])new String[]{"Long"}, Locale.getDefault()));
                throw new BaseException(this.messageSource, "error.idgen.greater.maxid");
            }
            nextId = bd.longValue();
        } else {
            Object object = this.mSemaphore;
            synchronized (object) {
                nextId = this.getNextLongIdInner();
            }
        }
        if (nextId > maxId) {
            this.getLogger().error((Object)this.messageSource.getMessage("error.idgen.greater.maxid", (Object[])new String[]{"Long"}, Locale.getDefault()));
            throw new BaseException(this.messageSource, "error.idgen.greater.maxid");
        }
        return nextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BigDecimal getNextBigDecimalId() throws BaseException {
        BigDecimal bd;
        if (this.mUseBigDecimals) {
            Object object = this.mSemaphore;
            synchronized (object) {
                bd = this.getNextBigDecimalIdInner();
            }
        }
        Object object = this.mSemaphore;
        synchronized (object) {
            bd = new BigDecimal(new Long(this.getNextLongIdInner()).doubleValue());
        }
        return bd;
    }

    public final long getNextLongId() throws BaseException {
        return this.getNextLongIdChecked(Long.MAX_VALUE);
    }

    public final int getNextIntegerId() throws BaseException {
        return (int)this.getNextLongIdChecked(Integer.MAX_VALUE);
    }

    public final short getNextShortId() throws BaseException {
        return (short)this.getNextLongIdChecked(32767L);
    }

    public final byte getNextByteId() throws BaseException {
        return (byte)this.getNextLongIdChecked(127L);
    }

    public final String getNextStringId() throws BaseException {
        return this.strategy.makeId(this.getNextBigDecimalId().toString());
    }

    public String getNextStringId(IdGenerationStrategy strategy) throws BaseException {
        this.strategy = strategy;
        return this.getNextStringId();
    }

    public String getNextStringId(String strategyId) throws BaseException {
        this.strategy = (IdGenerationStrategy)this.beanFactory.getBean(strategyId);
        return this.getNextStringId();
    }

    public IdGenerationStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(IdGenerationStrategy strategy) {
        this.strategy = strategy;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }
}

