/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.idgen.impl;

import anyframe.common.exception.BaseException;
import anyframe.core.idgen.impl.AbstractDataSourceIdGenerationService;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public abstract class SequenceIdGenerationService
extends AbstractDataSourceIdGenerationService {
    private String query;

    public abstract void setConfiguration(Configuration var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BigDecimal getNextBigDecimalIdInner() throws BaseException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)this.messageSource.getMessage("debug.idgen.sequenceid.query", (Object[])new String[]{this.query}, Locale.getDefault()));
        }
        try {
            Connection conn = this.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.query);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    BigDecimal bigDecimal = rs.getBigDecimal(1);
                    return bigDecimal;
                }
                if (!this.getLogger().isErrorEnabled()) throw new BaseException(this.messageSource, "error.idgen.sequenceid.notallocate.id");
                this.getLogger().error((Object)this.messageSource.getMessage("error.idgen.sequenceid.notallocate.id", (Object[])new String[0], Locale.getDefault()));
                throw new BaseException(this.messageSource, "error.idgen.sequenceid.notallocate.id");
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            if (!this.getLogger().isErrorEnabled()) throw new BaseException(this.messageSource, "error.idgen.get.connection", (Throwable)e);
            this.getLogger().error((Object)this.messageSource.getMessage("error.idgen.get.connection", (Object[])new String[0], Locale.getDefault()));
            throw new BaseException(this.messageSource, "error.idgen.get.connection", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getNextLongIdInner() throws BaseException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)this.messageSource.getMessage("debug.idgen.sequenceid.query", (Object[])new String[]{this.query}, Locale.getDefault()));
        }
        try {
            Connection conn = this.getConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(this.query);
                ResultSet rs = stmt.executeQuery();
                if (rs.next()) {
                    long l = rs.getLong(1);
                    return l;
                }
                if (!this.getLogger().isErrorEnabled()) throw new BaseException(this.messageSource, "error.idgen.sequenceid.notallocate.id");
                this.getLogger().error((Object)this.messageSource.getMessage("error.idgen.sequenceid.notallocate.id", (Object[])new String[0], Locale.getDefault()));
                throw new BaseException(this.messageSource, "error.idgen.sequenceid.notallocate.id");
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            if (!this.getLogger().isErrorEnabled()) throw new BaseException(this.messageSource, "error.idgen.get.connection", (Throwable)e);
            this.getLogger().error((Object)this.messageSource.getMessage("error.idgen.get.connection", (Object[])new String[0], Locale.getDefault()));
            throw new BaseException(this.messageSource, "error.idgen.get.connection", (Throwable)e);
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        if (configuration.getChild("query", false) == null) {
            throw new ConfigurationException("[IDGeneration Service] must have a <query>.");
        }
        this.query = configuration.getChild("query").getValue("");
        if (this.query.equals("")) {
            throw new ConfigurationException("[IDGeneration Service] must have a value in a <query>.");
        }
    }
}

