/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.idgen.impl;

import anyframe.common.exception.BaseException;
import anyframe.core.idgen.IIdGenerationService;
import anyframe.core.idgen.IdGenerationStrategy;
import anyframe.core.idgen.impl.Base64;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;

public abstract class UUIdGenerationService
implements IIdGenerationService,
Configurable,
ApplicationContextAware {
    private MessageSource messageSource;
    private static Log logger = LogFactory.getLog((Class)UUIdGenerationService.class);
    Configuration configuration;
    private static final String ERROR_STRING = "address in the configuration should be a valid IP or MAC Address";
    private String mAddressId;
    private String mTimeId;
    private short mLoopCounter = 0;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }

    public abstract void setConfiguration(Configuration var1);

    public BigDecimal getNextBigDecimalId() throws BaseException {
        String newId = this.getNextStringId();
        byte[] bytes = newId.getBytes();
        BigDecimal bd = new BigDecimal("0");
        for (int i = 0; i < bytes.length; ++i) {
            bd = bd.multiply(new BigDecimal("256"));
            bd = bd.add(new BigDecimal(new Integer(bytes[i] & 0xFF).doubleValue()));
        }
        return bd;
    }

    public byte getNextByteId() throws BaseException {
        throw new BaseException(this.messageSource, "error.idgen.not.supported", (Object[])new String[]{"Byte"});
    }

    public int getNextIntegerId() throws BaseException {
        throw new BaseException(this.messageSource, "error.idgen.not.supported", (Object[])new String[]{"Integer"});
    }

    public long getNextLongId() throws BaseException {
        throw new BaseException(this.messageSource, "error.idgen.not.supported", (Object[])new String[]{"Long"});
    }

    public short getNextShortId() throws BaseException {
        throw new BaseException(this.messageSource, "error.idgen.not.supported", (Object[])new String[]{"Short"});
    }

    public String getNextStringId() throws BaseException {
        return this.getUUId();
    }

    public String getNextStringId(IdGenerationStrategy strategy) throws BaseException {
        throw new BaseException(this.messageSource, "error.idgen.not.supported", (Object[])new String[]{"String"});
    }

    public String getNextStringId(String strategyId) throws BaseException {
        throw new BaseException(this.messageSource, "error.idgen.not.supported", (Object[])new String[]{"String"});
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String address;
        byte[] addressBytes = new byte[6];
        try {
            address = configuration.getChild("address").getValue();
        }
        catch (ConfigurationException ce) {
            address = null;
        }
        if (null == address) {
            logger.warn((Object)"IDGeneration Service : Using a random number as the base for id's.  This is not the best method for many purposes, but may be adequate in some circumstances. Consider using an IP or ethernet (MAC) address if available. ");
            for (int i = 0; i < 6; ++i) {
                addressBytes[i] = (byte)(255.0 * Math.random());
            }
        } else if (address.indexOf(".") > 0) {
            StringTokenizer stok = new StringTokenizer(address, ".");
            if (stok.countTokens() != 4) {
                throw new ConfigurationException(ERROR_STRING);
            }
            addressBytes[0] = -1;
            addressBytes[1] = -1;
            int i = 2;
            try {
                while (stok.hasMoreTokens()) {
                    addressBytes[i++] = Integer.valueOf(stok.nextToken(), 16).byteValue();
                }
            }
            catch (Exception e) {
                throw new ConfigurationException(ERROR_STRING, (Throwable)e);
            }
        } else if (address.indexOf(":") > 0) {
            StringTokenizer stok = new StringTokenizer(address, ":");
            if (stok.countTokens() != 6) {
                throw new ConfigurationException(ERROR_STRING);
            }
            int i = 0;
            try {
                while (stok.hasMoreTokens()) {
                    addressBytes[i++] = Integer.valueOf(stok.nextToken(), 16).byteValue();
                }
            }
            catch (Exception e) {
                throw new ConfigurationException(ERROR_STRING, (Throwable)e);
            }
        } else {
            throw new ConfigurationException(ERROR_STRING);
        }
        this.mAddressId = Base64.encode(addressBytes);
    }

    private String getUUId() {
        byte[] bytes6 = new byte[6];
        long timeNow = System.currentTimeMillis();
        timeNow = (int)timeNow & 0xFFFFFFFF;
        byte[] bytes4 = new byte[4];
        this.toFixSizeByteArray(new BigInteger(String.valueOf(timeNow)), bytes4);
        bytes6[0] = bytes4[0];
        bytes6[1] = bytes4[1];
        bytes6[2] = bytes4[2];
        bytes6[3] = bytes4[3];
        short counter = this.getLoopCounter();
        byte[] bytes2 = new byte[2];
        this.toFixSizeByteArray(new BigInteger(String.valueOf(counter)), bytes2);
        bytes6[4] = bytes2[0];
        bytes6[5] = bytes2[1];
        this.mTimeId = Base64.encode(bytes6);
        return (this.mAddressId + this.mTimeId).replace('+', '_').replace('/', '@');
    }

    private synchronized short getLoopCounter() {
        short s = this.mLoopCounter;
        this.mLoopCounter = (short)(s + 1);
        return s;
    }

    private void toFixSizeByteArray(BigInteger bigInt, byte[] destination) {
        for (int i = 0; i < destination.length; ++i) {
            destination[i] = 0;
        }
        byte[] source = bigInt.toByteArray();
        if (source.length <= destination.length) {
            for (int i = 0; i < source.length; ++i) {
                destination[destination.length - source.length + i] = source[i];
            }
        } else {
            for (int i = 0; i < destination.length; ++i) {
                destination[i] = source[source.length - destination.length + i];
            }
        }
    }
}

