/*
 * Decompiled with CFR 0.152.
 */
package anyframe.web.springmvc.controller;

import anyframe.common.exception.BaseException;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.BindException;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.servlet.mvc.multiaction.InternalPathMethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.MethodNameResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

public class AnyframeFormController
extends SimpleFormController
implements MessageSourceAware {
    private final Log anyframeLogger = LogFactory.getLog((Class)AnyframeFormController.class);
    private MessageSource messageSource;
    private String success_list = null;
    private String success_get = null;
    private String success_update = null;
    private String success_add = null;
    private String success_delete = null;
    private String success_addView = null;
    private boolean showNewForm = false;
    public static final String LAST_MODIFIED_METHOD_SUFFIX = "LastModified";
    public static final String PAGE_NOT_FOUND_LOG_CATEGORY = "org.springframework.web.servlet.PageNotFound";
    protected static final Log pageNotFoundLogger = LogFactory.getLog((String)"org.springframework.web.servlet.PageNotFound");
    private Object delegate;
    private MethodNameResolver methodNameResolver = new InternalPathMethodNameResolver();
    private final Map handlerMethodMap = new HashMap();
    private final Map lastModifiedMethodMap = new HashMap();
    private final Map exceptionHandlerMap = new HashMap();

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public Log getLogger() throws Exception {
        return LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    }

    public String getSuccess_list() {
        return this.success_list;
    }

    public void setSuccess_list(String success_list) {
        this.success_list = success_list;
    }

    public String getSuccess_get() {
        return this.success_get;
    }

    public void setSuccess_get(String success_get) {
        this.success_get = success_get;
    }

    public String getSuccess_update() {
        return this.success_update;
    }

    public void setSuccess_update(String success_update) {
        this.success_update = success_update;
    }

    public String getSuccess_add() {
        return this.success_add;
    }

    public void setSuccess_add(String success_add) {
        this.success_add = success_add;
    }

    public String getSuccess_delete() {
        return this.success_delete;
    }

    public void setSuccess_delete(String success_delete) {
        this.success_delete = success_delete;
    }

    public String getSuccess_addView() {
        return this.success_addView;
    }

    public void setSuccess_addView(String success_addView) {
        this.success_addView = success_addView;
    }

    public boolean isShowNewForm() {
        return this.showNewForm;
    }

    public void setShowNewForm(boolean showNewForm) {
        this.showNewForm = showNewForm;
    }

    public AnyframeFormController() {
        this.delegate = this;
        this.registerHandlerMethods(this.delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        ModelAndView result = null;
        try {
            this.preProcess(request, response);
            this.logger.debug((Object)(((Object)((Object)this)).getClass().getName() + " process() Started!"));
            result = this.process(request, response);
            this.logger.debug((Object)(((Object)((Object)this)).getClass().getName() + " process() Ended!"));
            this.postProcess(request, response);
        }
        catch (RuntimeException uncheckedException) {
            result = this.processUnCheckedException(request, response, uncheckedException);
            result = this.processFinally(request, response, result);
        }
        catch (Exception checkedException) {
            this.logger.debug((Object)"\n Controller Exception catch!!");
            result = this.processCheckedException(request, response, checkedException);
            {
                catch (Throwable throwable) {
                    result = this.processFinally(request, response, result);
                    throw throwable;
                }
            }
            result = this.processFinally(request, response, result);
        }
        result = this.processFinally(request, response, result);
        return result;
    }

    protected void preProcess(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    protected void postProcess(HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    protected ModelAndView processCheckedException(HttpServletRequest request, HttpServletResponse response, Exception checkedException) throws Exception {
        throw checkedException;
    }

    protected ModelAndView processUnCheckedException(HttpServletRequest request, HttpServletResponse response, RuntimeException uncheckedException) throws Exception {
        throw uncheckedException;
    }

    protected ModelAndView processFinally(HttpServletRequest request, HttpServletResponse response, ModelAndView result) throws Exception {
        return result;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isSessionForm()) {
            if (this.isShowNewForm()) {
                return this.showNewForm(request, response);
            }
            try {
                Object command = this.getCommand(request);
                ServletRequestDataBinder binder = this.bindAndValidate(request, command);
                BindException errors = new BindException(binder.getBindingResult());
                return this.processFormSubmission(request, response, command, errors);
            }
            catch (HttpSessionRequiredException ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Invalid submit detected: " + ex.getMessage()));
                }
                return this.handleInvalidSubmit(request, response);
            }
        }
        return this.onSubmit(request, response, null, null);
    }

    protected ModelAndView process(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String methodName = this.methodNameResolver.getHandlerMethodName(request);
            return this.invokeNamedMethod(methodName, request, response);
        }
        catch (NoSuchRequestHandlingMethodException ex) {
            return this.handleNoSuchRequestHandlingMethod(ex, request, response);
        }
    }

    public final void setDelegate(Object delegate) {
        Assert.notNull((Object)delegate, (String)"Delegate must not be null");
        this.delegate = delegate;
        this.registerHandlerMethods(this.delegate);
        if (this.handlerMethodMap.isEmpty()) {
            throw new IllegalStateException("No handler methods in class [" + this.delegate.getClass() + "]");
        }
    }

    public final void setMethodNameResolver(MethodNameResolver methodNameResolver) {
        this.methodNameResolver = methodNameResolver;
    }

    public final MethodNameResolver getMethodNameResolver() {
        return this.methodNameResolver;
    }

    private void registerHandlerMethods(Object delegate) {
        this.handlerMethodMap.clear();
        this.lastModifiedMethodMap.clear();
        this.exceptionHandlerMap.clear();
        Method[] methods = delegate.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (this.isExceptionHandlerMethod(method)) {
                this.registerExceptionHandlerMethod(method);
                continue;
            }
            if (!this.isHandlerMethod(method)) continue;
            this.registerHandlerMethod(method);
            this.registerLastModifiedMethodIfExists(delegate, method);
        }
    }

    private boolean isHandlerMethod(Method method) {
        Class<?> returnType;
        if (ModelAndView.class.equals(returnType = method.getReturnType()) || Map.class.equals(returnType) || String.class.equals(returnType) || Void.TYPE.equals(returnType)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            return parameterTypes.length >= 2 && HttpServletRequest.class.equals(parameterTypes[0]) && HttpServletResponse.class.equals(parameterTypes[1]) && (!"handleRequest".equals(method.getName()) || parameterTypes.length != 2);
        }
        return false;
    }

    private boolean isExceptionHandlerMethod(Method method) {
        return this.isHandlerMethod(method) && method.getParameterTypes().length == 3 && Throwable.class.isAssignableFrom(method.getParameterTypes()[2]);
    }

    private void registerHandlerMethod(Method method) {
        if (this.anyframeLogger.isDebugEnabled()) {
            this.anyframeLogger.debug((Object)("Found action method [" + method + "]"));
        }
        this.handlerMethodMap.put(method.getName(), method);
    }

    private void registerLastModifiedMethodIfExists(Object delegate, Method method) {
        try {
            Method lastModifiedMethod = delegate.getClass().getMethod(method.getName() + LAST_MODIFIED_METHOD_SUFFIX, HttpServletRequest.class);
            Class<?> returnType = lastModifiedMethod.getReturnType();
            if (!Long.TYPE.equals(returnType) && !Long.class.equals(returnType)) {
                throw new IllegalStateException("last-modified method [" + lastModifiedMethod + "] declares an invalid return type - needs to be 'long' or 'Long'");
            }
            this.lastModifiedMethodMap.put(method.getName(), lastModifiedMethod);
            if (this.anyframeLogger.isDebugEnabled()) {
                this.anyframeLogger.debug((Object)("Found last-modified method for handler method [" + method + "]"));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void registerExceptionHandlerMethod(Method method) {
        this.exceptionHandlerMap.put(method.getParameterTypes()[2], method);
        if (this.anyframeLogger.isDebugEnabled()) {
            this.anyframeLogger.debug((Object)("Found exception handler method [" + method + "]"));
        }
    }

    public long getLastModified(HttpServletRequest request) {
        try {
            String handlerMethodName = this.methodNameResolver.getHandlerMethodName(request);
            Method lastModifiedMethod = (Method)this.lastModifiedMethodMap.get(handlerMethodName);
            if (lastModifiedMethod != null) {
                try {
                    Long wrappedLong = (Long)lastModifiedMethod.invoke(this.delegate, request);
                    return wrappedLong != null ? wrappedLong : -1L;
                }
                catch (Exception ex) {
                    this.anyframeLogger.error((Object)"Failed to invoke last-modified method", (Throwable)ex);
                }
            }
        }
        catch (NoSuchRequestHandlingMethodException noSuchRequestHandlingMethodException) {
            // empty catch block
        }
        return -1L;
    }

    protected ModelAndView handleNoSuchRequestHandlingMethod(NoSuchRequestHandlingMethodException ex, HttpServletRequest request, HttpServletResponse response) throws Exception {
        pageNotFoundLogger.warn((Object)ex.getMessage());
        response.sendError(404);
        return null;
    }

    protected final ModelAndView invokeNamedMethod(String methodName, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Method method = (Method)this.handlerMethodMap.get(methodName);
        if (method == null) {
            throw new NoSuchRequestHandlingMethodException(methodName, ((Object)((Object)this)).getClass());
        }
        try {
            Class<?>[] paramTypes = method.getParameterTypes();
            ArrayList<Object> params = new ArrayList<Object>(4);
            params.add(request);
            params.add(response);
            if (paramTypes.length >= 3 && paramTypes[2].equals(HttpSession.class)) {
                HttpSession session = request.getSession(false);
                if (session == null) {
                    throw new HttpSessionRequiredException("Pre-existing session required for handler method '" + methodName + "'");
                }
                params.add(session);
            }
            if (paramTypes.length >= 3 && !paramTypes[paramTypes.length - 1].equals(HttpSession.class)) {
                Object command = this.newCommandObject(paramTypes[paramTypes.length - 1]);
                params.add(command);
                this.bind(request, command);
            }
            Object returnValue = method.invoke(this.delegate, params.toArray(new Object[params.size()]));
            return this.massageReturnValueIfNecessary(returnValue);
        }
        catch (InvocationTargetException ex) {
            return this.handleException(request, response, ex.getTargetException());
        }
        catch (Exception ex) {
            return this.handleException(request, response, ex);
        }
    }

    private ModelAndView massageReturnValueIfNecessary(Object returnValue) {
        if (returnValue instanceof ModelAndView) {
            return (ModelAndView)returnValue;
        }
        if (returnValue instanceof Map) {
            return new ModelAndView().addAllObjects((Map)returnValue);
        }
        if (returnValue instanceof String) {
            return new ModelAndView((String)returnValue);
        }
        return null;
    }

    protected Object newCommandObject(Class clazz) throws Exception {
        if (this.anyframeLogger.isDebugEnabled()) {
            this.anyframeLogger.debug((Object)("Creating new command of class [" + clazz.getName() + "]"));
        }
        return BeanUtils.instantiateClass((Class)clazz);
    }

    protected void bind(HttpServletRequest request, Object command) throws Exception {
        if (this.anyframeLogger.isDebugEnabled()) {
            this.anyframeLogger.debug((Object)"Binding request parameters onto MultiActionController command");
        }
        ServletRequestDataBinder binder = this.createBinder(request, command);
        binder.bind((ServletRequest)request);
        binder.closeNoCatch();
    }

    protected Method getExceptionHandler(Throwable exception) {
        Class<?> exceptionClass = exception.getClass();
        if (this.anyframeLogger.isDebugEnabled()) {
            this.anyframeLogger.debug((Object)("Trying to find handler for exception class [" + exceptionClass.getName() + "]"));
        }
        Method handler = (Method)this.exceptionHandlerMap.get(exceptionClass);
        while (handler == null && !exceptionClass.equals(class$java$lang$Throwable == null ? AnyframeFormController.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
            if (this.anyframeLogger.isDebugEnabled()) {
                this.anyframeLogger.debug((Object)("Trying to find handler for exception superclass [" + exceptionClass.getName() + "]"));
            }
            exceptionClass = exceptionClass.getSuperclass();
            handler = (Method)this.exceptionHandlerMap.get(exceptionClass);
        }
        return handler;
    }

    private ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Throwable ex) throws Exception {
        Method handler = this.getExceptionHandler(ex);
        if (handler != null) {
            if (this.anyframeLogger.isDebugEnabled()) {
                this.anyframeLogger.debug((Object)("Invoking exception handler [" + handler + "] for exception: " + ex));
            }
            try {
                Object returnValue = handler.invoke(this.delegate, request, response, ex);
                return this.massageReturnValueIfNecessary(returnValue);
            }
            catch (InvocationTargetException ex2) {
                this.anyframeLogger.error((Object)"Original exception overridden by exception handling failure", ex);
                ReflectionUtils.rethrowException((Throwable)ex2.getTargetException());
            }
            catch (Exception ex2) {
                this.anyframeLogger.error((Object)"Failed to invoke exception handler method", (Throwable)ex2);
            }
        } else {
            ReflectionUtils.rethrowException((Throwable)ex);
        }
        throw new IllegalStateException("Should never get here");
    }

    protected ModelAndView handleInvalidSubmit(HttpServletRequest request, HttpServletResponse response) throws Exception {
        throw new BaseException(new String(this.messageSource.getMessage("common.msg.invalidtoken.error", (Object[])new String[0], Locale.getDefault())));
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        CustomDateEditor dateEdit = new CustomDateEditor((DateFormat)df, false);
        binder.registerCustomEditor(Date.class, (PropertyEditor)dateEdit);
    }
}

