/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query;

import anyframe.common.Page;
import anyframe.core.query.IQueryService;
import anyframe.core.query.QueryServiceException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AbstractDAO {
    private String variableName = "vo";
    private String createId = "create";
    private String updateId = "update";
    private String removeId = "remove";
    private String findPrefix = "find";
    private String findListPostfix = "List";
    private String findByPkPostfix = "ByPk";
    private IQueryService queryService;

    public IQueryService getQueryService() {
        return this.queryService;
    }

    public void setQueryService(IQueryService queryService) {
        this.queryService = queryService;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void setCreateId(String createId) {
        this.createId = createId;
    }

    public void setRemoveId(String removeId) {
        this.removeId = removeId;
    }

    public void setUpdateId(String updateId) {
        this.updateId = updateId;
    }

    public void setFindPrefix(String findPrefix) {
        this.findPrefix = findPrefix;
    }

    public void setFindByPkPostfix(String findByPkPostfix) {
        this.findByPkPostfix = findByPkPostfix;
    }

    public void setFindListPostfix(String findListPostfix) {
        this.findListPostfix = findListPostfix;
    }

    protected int create(String tableName, Object targetObj) throws QueryServiceException {
        Object[] params = this.convertParams(targetObj);
        return this.create(tableName, params);
    }

    protected int create(String tableName, Map targetMap) throws QueryServiceException {
        Object[] params = this.convertParams(targetMap);
        return this.create(tableName, params);
    }

    protected int create(String tableName, Object targetObj1, Object targetObj2) throws QueryServiceException {
        Object[] params = this.convertParams(targetObj1, targetObj2);
        return this.create(tableName, params);
    }

    protected int create(String tableName, List targetList) throws QueryServiceException {
        Object[] params = this.convertParams(targetList);
        return this.create(tableName, params);
    }

    protected int create(String tableName, Object[] targetObjs) throws QueryServiceException {
        return this.queryService.create(this.createId + tableName, targetObjs);
    }

    protected int update(String tableName, Object targetObj) throws QueryServiceException {
        Object[] params = this.convertParams(targetObj);
        return this.update(tableName, params);
    }

    protected int update(String tableName, Map targetMap) throws QueryServiceException {
        Object[] params = this.convertParams(targetMap);
        return this.update(tableName, params);
    }

    protected int update(String tableName, List targetList) throws QueryServiceException {
        Object[] params = this.convertParams(targetList);
        return this.update(tableName, params);
    }

    protected int update(String tableName, Object targetObj1, Object targetObj2) throws QueryServiceException {
        Object[] params = this.convertParams(targetObj1, targetObj2);
        return this.update(tableName, params);
    }

    protected int update(String tableName, Object[] targetObjs) throws QueryServiceException {
        return this.queryService.update(this.updateId + tableName, targetObjs);
    }

    protected int remove(String tableName, Object targetObj) throws QueryServiceException {
        Object[] params = this.convertParams(targetObj);
        return this.remove(tableName, params);
    }

    protected int remove(String tableName, Map targetMap) throws QueryServiceException {
        Object[] params = this.convertParams(targetMap);
        return this.remove(tableName, params);
    }

    protected int remove(String tableName, Object targetObj1, Object targetObj2) throws QueryServiceException {
        Object[] params = this.convertParams(targetObj1, targetObj2);
        return this.remove(tableName, params);
    }

    protected int remove(String tableName, List targetObjs) throws QueryServiceException {
        Object[] params = this.convertParams(targetObjs);
        return this.remove(tableName, params);
    }

    protected int remove(String tableName, Object[] targetObjs) throws QueryServiceException {
        return this.queryService.remove(this.removeId + tableName, targetObjs);
    }

    protected Object findByPk(String tableName, Object targetObj) throws QueryServiceException {
        Object[] params = this.convertParams(targetObj);
        return this.findByPk(tableName, params);
    }

    protected Object findByPk(String tableName, Map targetMap) throws QueryServiceException {
        Object[] params = this.convertParams(targetMap);
        return this.findByPk(tableName, params);
    }

    protected Object findByPk(String tableName, List targetList) throws QueryServiceException {
        Object[] params = this.convertParams(targetList);
        return this.findByPk(tableName, params);
    }

    protected Object findByPk(String tableName, Object[] targetObjs) throws QueryServiceException {
        Collection collection = this.queryService.find(this.findPrefix + tableName + this.findByPkPostfix, targetObjs, 0, 0);
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return collection.iterator().next();
    }

    protected Collection findList(String tableName, Object targetObj) throws QueryServiceException {
        return this.findList(tableName, targetObj, 0, 0);
    }

    protected Collection findList(String tableName, Map targetMap) throws QueryServiceException {
        return this.findList(tableName, targetMap, 0, 0);
    }

    protected Collection findList(String tableName, List targetObjs) throws QueryServiceException {
        return this.findList(tableName, targetObjs, 0, 0);
    }

    protected Collection findList(String tableName, Object[] targetObjs) throws QueryServiceException {
        return this.findList(tableName, targetObjs, 0, 0);
    }

    protected Collection findList(String tableName, Object targetObj, int pageIndex, int pageSize) throws QueryServiceException {
        Object[] params = this.convertParams(targetObj);
        return this.findList(tableName, params, pageIndex, pageSize);
    }

    protected Collection findList(String tableName, Map targetMap, int pageIndex, int pageSize) throws QueryServiceException {
        Object[] params = this.convertParams(targetMap);
        return this.findList(tableName, params, pageIndex, pageSize);
    }

    protected Collection findList(String tableName, List targetList, int pageIndex, int pageSize) throws QueryServiceException {
        Object[] params = this.convertParams(targetList);
        return this.findList(tableName, params, pageIndex, pageSize);
    }

    private Collection findList(String tableName, Object[] targetObjs, int pageIndex, int pageSize) throws QueryServiceException {
        return this.queryService.find(this.findPrefix + tableName + this.findListPostfix, targetObjs, pageIndex, pageSize);
    }

    protected Page findListWithPaging(String tableName, Object targetObj, int pageIndex, int pageSize) throws QueryServiceException {
        return this.findListWithPaging(tableName, targetObj, pageIndex, pageSize, 10);
    }

    protected Page findListWithPaging(String tableName, Object targetObj, int pageIndex, int pageSize, int pageUnit) throws QueryServiceException {
        Object[] params = this.convertParams(targetObj);
        return this.findListWithPaging(tableName, params, pageIndex, pageSize, pageUnit);
    }

    protected Page findListWithPaging(String tableName, Map targetMap, int pageIndex, int pageSize) throws QueryServiceException {
        return this.findListWithPaging(tableName, targetMap, pageIndex, pageSize, 10);
    }

    protected Page findListWithPaging(String tableName, Map targetMap, int pageIndex, int pageSize, int pageUnit) throws QueryServiceException {
        Object[] params = this.convertParams(targetMap);
        return this.findListWithPaging(tableName, params, pageIndex, pageSize, pageUnit);
    }

    protected Page findListWithPaging(String tableName, List targetObjs, int pageIndex, int pageSize) throws QueryServiceException {
        return this.findListWithPaging(tableName, targetObjs, pageIndex, pageSize, 10);
    }

    protected Page findListWithPaging(String tableName, List targetObjs, int pageIndex, int pageSize, int pageUnit) throws QueryServiceException {
        Object[] params = this.convertParams(targetObjs);
        return this.findListWithPaging(tableName, params, pageIndex, pageSize, pageUnit);
    }

    protected Page findListWithPaging(String tableName, Object[] targetObjs, int pageIndex, int pageSize) throws QueryServiceException {
        return this.findListWithPaging(tableName, targetObjs, pageIndex, pageSize, 10);
    }

    protected Page findListWithPaging(String tableName, Object[] targetObjs, int pageIndex, int pageSize, int pageUnit) throws QueryServiceException {
        Map queryMap = null;
        queryMap = this.queryService.findWithRowCount(this.findPrefix + tableName + this.findListPostfix, targetObjs, pageIndex, pageSize);
        List resultList = (List)queryMap.get("LIST");
        int totalSize = ((Long)queryMap.get("COUNT")).intValue();
        return new Page((Collection)resultList, new Integer(pageIndex).intValue(), totalSize, pageUnit, pageSize);
    }

    private Object[] convertParams(Object targetObj) {
        return new Object[]{new Object[]{this.variableName, targetObj}};
    }

    private Object[] convertParams(Object targetObj1, Object targetObj2) {
        return new Object[]{new Object[]{this.variableName + "1", targetObj1}, new Object[]{this.variableName + "2", targetObj2}};
    }

    private Object[] convertParams(Map targetMap) {
        Object[] params = new Object[targetMap.size()];
        Iterator targetMapIterator = targetMap.entrySet().iterator();
        int i = 0;
        while (targetMapIterator.hasNext()) {
            Map.Entry entry = targetMapIterator.next();
            params[i] = new Object[]{entry.getKey(), entry.getValue()};
            ++i;
        }
        return params;
    }

    private Object[] convertParams(List targetList) {
        Object[] params = new Object[targetList.size()];
        int size = targetList.size();
        for (int i = 0; i < size; ++i) {
            params[i] = new Object[]{this.variableName + (i + 1), targetList.get(i)};
        }
        return params;
    }
}

