/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl;

import anyframe.common.util.StringUtil;
import anyframe.core.query.IQueryService;
import anyframe.core.query.QueryServiceException;
import anyframe.core.query.impl.config.loader.SQLLoader;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.velocity.app.Velocity;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class AbstractQueryService
implements ApplicationContextAware,
ResourceLoaderAware,
InitializingBean {
    private SQLLoader sqlRepository = null;
    private MessageSource messageSource = null;
    private String propsFilename;
    private ResourceLoader resourceLoader = null;

    public void setVelocityPropsFilename(String propsFilename) {
        this.propsFilename = propsFilename;
    }

    protected MessageSource getMessageSource() {
        return this.messageSource;
    }

    public SQLLoader getSqlRepository() {
        return this.sqlRepository;
    }

    public void setSqlRepository(SQLLoader sqlRepository) {
        this.sqlRepository = sqlRepository;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.messageSource = (MessageSource)context.getBean("messageSource");
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void afterPropertiesSet() throws Exception {
        block4: {
            try {
                if (StringUtil.isEmpty((String)this.propsFilename)) {
                    Velocity.addProperty((String)"runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogSystem");
                    Velocity.init();
                    break block4;
                }
                Resource[] resources = ((ResourcePatternResolver)this.resourceLoader).getResources(this.propsFilename);
                File velocityLogFile = resources[0].getFile();
                if (velocityLogFile.exists()) {
                    Velocity.addProperty((String)"runtime.log", (Object)velocityLogFile.getAbsolutePath());
                    Velocity.init();
                    break block4;
                }
                throw new Exception("Velocity log file doesn't exists.");
            }
            catch (Exception e) {
                IQueryService.LOGGER.error((Object)this.messageSource.getMessage("error.query.initialize.velocity", (Object[])new String[0], Locale.getDefault()), (Throwable)e);
                throw new Exception("Query Service : Fail to initialize Velocity.", e);
            }
        }
    }

    protected String getRunnableSQL(String sql, SqlParameterSource searchParams) throws QueryServiceException {
        StringBuffer tempStatement = new StringBuffer(sql);
        SortedMap replacementPositions = this.findTextReplacements(tempStatement);
        Iterator properties = replacementPositions.entrySet().iterator();
        int valueLengths = 0;
        while (properties.hasNext()) {
            Map.Entry entry = properties.next();
            Integer pos = (Integer)entry.getKey();
            String key = (String)entry.getValue();
            String replaceValue = (String)searchParams.getValue(key);
            if (replaceValue == null) {
                throw new QueryServiceException(this.getMessageSource(), "error.query.runnablesql.replace", new Object[]{entry.getValue()});
            }
            String value = replaceValue.toString();
            tempStatement.insert(pos + valueLengths, value);
            valueLengths += value.length();
        }
        return tempStatement.toString();
    }

    protected SortedMap findTextReplacements(StringBuffer sql) {
        TreeMap<Integer, String> textReplacements = new TreeMap<Integer, String>();
        int startPos = 0;
        while ((startPos = sql.indexOf("{{", startPos)) > -1) {
            int endPos = sql.indexOf("}}", startPos);
            String replacementKey = sql.substring(startPos + 2, endPos);
            sql.replace(startPos, endPos + 2, "");
            textReplacements.put(new Integer(startPos), replacementKey);
        }
        return textReplacements;
    }

    protected boolean isVelocity(String sql) {
        return (sql.indexOf("#if") > -1 || sql.indexOf("#foreach") > -1) && sql.indexOf("#end") > -1;
    }

    protected void containesQueryId(String queryId) throws QueryServiceException {
        if (!this.getSqlRepository().hasQuery(queryId)) {
            throw new QueryServiceException(this.getMessageSource(), "error.query.common.checkid", new Object[]{queryId});
        }
    }
}

