/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl;

import anyframe.core.query.IQueryService;

public class PaginationVO {
    private long recordCount;
    private int pageSize = 20;
    private int pageIndex = 1;
    private boolean isPaging = true;
    private boolean countRecordSize = false;

    public boolean isPaging() {
        return this.isPaging;
    }

    public void setPaging(boolean isPaging) {
        this.isPaging = isPaging;
    }

    public boolean isCountRecordSize() {
        return this.countRecordSize;
    }

    public void setCountRecordSize(boolean countRecordSize) {
        this.countRecordSize = countRecordSize;
    }

    public PaginationVO() {
    }

    public PaginationVO(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(long recordCount) {
        this.recordCount = recordCount;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        if (this.isPaging && pageIndex < 1) {
            IQueryService.LOGGER.warn((Object)("Page number must have over 1. (current page number = " + pageIndex + ")"));
        }
        this.pageIndex = pageIndex;
    }

    public void setPageIndexToLast() {
        if (this.isPaging && this.pageIndex > this.getPageCount()) {
            IQueryService.LOGGER.warn((Object)("Current page number is bigger than last page number of result. (current page number = " + this.pageIndex + ", last page number = " + this.getPageCount()));
        }
    }

    public int getPageCount() {
        int iRecordCount = new Long(this.recordCount).intValue();
        if (this.pageSize == 0) {
            return iRecordCount;
        }
        if (this.recordCount % (long)this.pageSize == 0L) {
            return iRecordCount / this.pageSize;
        }
        return iRecordCount / this.pageSize + 1;
    }
}

