/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl;

import anyframe.core.query.IMappingInfo;
import anyframe.core.query.IQueryInfo;
import anyframe.core.query.IQueryService;
import anyframe.core.query.IResultSetMapper;
import anyframe.core.query.QueryServiceException;
import anyframe.core.query.impl.AbstractQueryService;
import anyframe.core.query.impl.PaginationVO;
import anyframe.core.query.impl.jdbc.PagingJdbcTemplate;
import anyframe.core.query.impl.jdbc.PagingNamedParamJdbcTemplate;
import anyframe.core.query.impl.jdbc.generator.IPagingSQLGenerator;
import anyframe.core.query.impl.jdbc.mapper.CallbackResultSetMapper;
import anyframe.core.query.impl.jdbc.setter.ExtMapSqlParameterSource;
import anyframe.core.query.impl.jdbc.setter.ExtMapSqlParameterSourceContext;
import anyframe.core.query.impl.jdbc.setter.PreparedStatementArgTypeSetter;
import anyframe.core.query.impl.util.InternalDataAccessException;
import anyframe.core.query.impl.util.NamedParameterUtils;
import anyframe.core.query.impl.util.ParsedSql;
import anyframe.core.query.impl.util.SQLTypeTransfer;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.CallableStatementCreatorFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.object.BatchSqlUpdate;
import org.springframework.jdbc.support.lob.LobHandler;

public class QueryServiceImpl
extends AbstractQueryService
implements IQueryService {
    private static final String DELIMETER = "=";
    private PagingJdbcTemplate jdbcTemplate;
    private PagingNamedParamJdbcTemplate namedJdbcTemplate = null;
    private LobHandler lobHandler;

    public void setJdbcTemplate(PagingJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedJdbcTemplate = new PagingNamedParamJdbcTemplate(jdbcTemplate, jdbcTemplate.getDataSource());
        this.namedJdbcTemplate.setExceptionTranslator(jdbcTemplate.getExceptionTranslator());
    }

    public void setPagingSQLGenerator(IPagingSQLGenerator pagingSQLGenerator) {
        this.jdbcTemplate.setPaginationSQLGetter(pagingSQLGenerator);
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public LobHandler getLobHandler() {
        return this.lobHandler;
    }

    public int[] batchCreate(List targets) throws QueryServiceException {
        String sql = "";
        String className = "";
        try {
            className = targets.get(0).getClass().getName();
            IMappingInfo mappingInfo = (IMappingInfo)this.getSqlRepository().getMappingInfos().get(className);
            sql = mappingInfo.getInsertQuery();
            return this.batchDynamicExecutor(sql, targets);
        }
        catch (Exception e) {
            throw this.processException("batch-insert using object " + className + " defined table mapping", sql, e);
        }
    }

    public int[] batchRemove(List targets) throws QueryServiceException {
        String sql = "";
        String className = "";
        try {
            className = targets.get(0).getClass().getName();
            IMappingInfo mappingInfo = (IMappingInfo)this.getSqlRepository().getMappingInfos().get(className);
            sql = mappingInfo.getDeleteQuery();
            return this.batchDynamicExecutor(sql, targets);
        }
        catch (Exception e) {
            throw this.processException("batch-remove using object " + className + " defined table mapping", sql, e);
        }
    }

    public int[] batchUpdate(List targets) throws QueryServiceException {
        String sql = "";
        String className = "";
        try {
            className = targets.get(0).getClass().getName();
            IMappingInfo mappingInfo = (IMappingInfo)this.getSqlRepository().getMappingInfos().get(className);
            sql = mappingInfo.getUpdateQuery();
            return this.batchDynamicExecutor(sql, targets);
        }
        catch (Exception e) {
            throw this.processException("batch-update using object " + className + " defined table mapping", sql, e);
        }
    }

    public int[] batchUpdate(String queryId, List targets) throws QueryServiceException {
        String sql = "";
        try {
            this.containesQueryId(queryId);
            IQueryInfo queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
            sql = queryInfo.getQueryString();
            if (queryInfo.isDynamic()) {
                return this.batchDynamicExecutor(sql, targets);
            }
            return this.batchStaticExecutor(sql, targets);
        }
        catch (Exception e) {
            throw this.processException("batch-update [query id = '" + queryId + "']", sql, e);
        }
    }

    public int[] batchUpdateBySQL(String sql, String[] types, List targets) throws QueryServiceException {
        try {
            return this.batchExecutor(sql, this.convertTypes(types), targets);
        }
        catch (Exception e) {
            throw this.processException("batch update by SQL", sql, e);
        }
    }

    public int create(Object obj) throws QueryServiceException {
        String sql = "";
        String className = "";
        try {
            className = obj.getClass().getName();
            IMappingInfo mappingInfo = (IMappingInfo)this.getSqlRepository().getMappingInfos().get(className);
            sql = mappingInfo.getInsertQuery();
            return this.objectCUDExecutor(obj, sql);
        }
        catch (Exception e) {
            throw this.processException("insert using object " + className + " defined table mapping", sql, e);
        }
    }

    public int create(String queryId, Object[] values) throws QueryServiceException {
        IQueryInfo queryInfo = null;
        try {
            this.containesQueryId(queryId);
            queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
            return this.sqlCUDExecutor(queryInfo, values);
        }
        catch (Exception e) {
            throw this.processException("insert [query id = '" + queryId + "']", this.getQueryString(queryInfo), e);
        }
    }

    public int createBySQL(String sql, String[] types, Object[] values) throws QueryServiceException {
        try {
            return this.sqlCUDExecutor(sql, values, this.convertTypes(types), false, null, null, null);
        }
        catch (Exception e) {
            throw this.processException("insert by SQL", sql, e);
        }
    }

    public Map execute(String queryId, Map values) throws QueryServiceException {
        return this.execute(queryId, values, 0);
    }

    public Map execute(String queryId, Map values, int pageIndex) throws QueryServiceException {
        return this.execute(queryId, values, pageIndex, -1);
    }

    public Map execute(String queryId, Map values, int pageIndex, int pageSize) throws QueryServiceException {
        String sql = "";
        try {
            this.containesQueryId(queryId);
            if (pageSize == -1) {
                pageSize = this.getSqlRepository().getFetchCountPerQuery(queryId);
            }
            IQueryInfo queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
            sql = queryInfo.getQueryString();
            List paramList = queryInfo.getSqlParameterList();
            CallableStatementCreator callableStatementCreator = new CallableStatementCreatorFactory(sql, paramList).newCallableStatementCreator(values);
            return this.jdbcTemplate.call(callableStatementCreator, paramList);
        }
        catch (Exception e) {
            throw this.processException("execute statement [query id = '" + queryId + "']", sql, e);
        }
    }

    public Map executeBySQL(String query, String[] paramTypeNames, String[] paramBindingNames, String[] paramBindingTypes, Map values) throws QueryServiceException {
        return this.executeBySQL(query, paramTypeNames, paramBindingNames, paramBindingTypes, values, 0, 0);
    }

    public Map executeBySQL(String sql, String[] paramTypeNames, String[] paramBindingNames, String[] paramBindingTypes, Map values, int pageIndex, int pageSize) throws QueryServiceException {
        try {
            List paramList = SQLTypeTransfer.getSqlParameterList(paramTypeNames, paramBindingTypes, paramBindingNames);
            CallableStatementCreator callableStatementCreator = new CallableStatementCreatorFactory(sql, paramList).newCallableStatementCreator(values);
            return this.jdbcTemplate.call(callableStatementCreator, paramList);
        }
        catch (Exception e) {
            throw this.processException("execute by SQL", sql, e);
        }
    }

    public Collection find(String queryId, Object[] values) throws QueryServiceException {
        return this.find(queryId, values, -1, -1, false);
    }

    public Collection find(String queryId, Object[] values, int pageIndex) throws QueryServiceException {
        return this.find(queryId, values, pageIndex, -1, true);
    }

    public Collection find(Object obj) throws QueryServiceException {
        String sql = "";
        String className = "";
        try {
            className = obj.getClass().getName();
            IMappingInfo mappingInfo = (IMappingInfo)this.getSqlRepository().getMappingInfos().get(className);
            sql = mappingInfo.getSelectByPrimaryKeyQuery();
            CallbackResultSetMapper rowCallbackHandler = new CallbackResultSetMapper(Class.forName(className), mappingInfo, this.lobHandler, this.getSqlRepository().getNullCheck(), "none");
            HashMap<String, Object> inputMap = new HashMap<String, Object>();
            inputMap.put("anyframe", obj);
            ExtMapSqlParameterSource sqlParameterSource = new ExtMapSqlParameterSource(inputMap);
            this.namedJdbcTemplate.query(sql, sqlParameterSource, rowCallbackHandler);
            return rowCallbackHandler.getObjects();
        }
        catch (Exception e) {
            throw this.processException("select using object " + className + " defined table mapping", sql, e);
        }
    }

    public Collection find(String queryId, Object[] values, int pageIndex, int pageSize) throws QueryServiceException {
        return this.find(queryId, values, pageIndex, pageSize, true);
    }

    public Collection findBySQL(String sql, String[] types, Object[] values) throws QueryServiceException {
        try {
            return this.jdbcTemplate.queryForList(sql, values, this.convertTypes(types));
        }
        catch (Exception e) {
            throw this.processException("select by SQL", sql, e);
        }
    }

    public Collection findBySQL(String sql, String[] types, Object[] values, int pageIndex, int pageSize) throws QueryServiceException {
        try {
            PaginationVO paginationVO = new PaginationVO(pageSize);
            paginationVO.setPageIndex(pageIndex);
            return this.jdbcTemplate.queryForListWithPagination(sql, values, this.convertTypes(types), paginationVO);
        }
        catch (Exception e) {
            throw this.processException("select by SQL", sql, e);
        }
    }

    public Map findBySQLWithRowCount(String sql, String[] types, Object[] values) throws QueryServiceException {
        return this.findBySQLWithRowCount(sql, types, values, -1, -1);
    }

    public Map findBySQLWithRowCount(String sql, String[] types, Object[] values, int pageIndex, int pageSize) throws QueryServiceException {
        try {
            PaginationVO paginationVO = new PaginationVO(pageSize);
            paginationVO.setPageIndex(pageIndex);
            paginationVO.setCountRecordSize(true);
            List list = this.jdbcTemplate.queryForListWithPagination(sql, values, this.convertTypes(types), paginationVO);
            return this.makeResultMap(list, paginationVO.getRecordCount(), null);
        }
        catch (Exception e) {
            throw this.processException("select by paging SQL", sql, e);
        }
    }

    public Map findWithColInfo(String queryId, Object[] values) throws QueryServiceException {
        return this.findWithColInfo(queryId, values, -1, -1, false);
    }

    public Map findWithColInfo(String queryId, Object[] values, int pageIndex) throws QueryServiceException {
        return this.findWithColInfo(queryId, values, pageIndex, -1, true);
    }

    public Map findWithColInfo(String queryId, Object[] values, int pageIndex, int pageSize) throws QueryServiceException {
        return this.findWithColInfo(queryId, values, pageIndex, pageSize, true);
    }

    public Map findWithRowCount(String queryId, Object[] values) throws QueryServiceException {
        return this.findWithRowCount(queryId, values, -1, -1, false);
    }

    public Map findWithRowCount(String queryId, Object[] values, int pageIndex) throws QueryServiceException {
        return this.findWithRowCount(queryId, values, pageIndex, -1, true);
    }

    public Map findWithRowCount(String queryId, Object[] values, int pageIndex, int pageSize) throws QueryServiceException {
        return this.findWithRowCount(queryId, values, pageIndex, pageSize, true);
    }

    public int remove(Object obj) throws QueryServiceException {
        String sql = "";
        String className = "";
        try {
            className = obj.getClass().getName();
            IMappingInfo mappingInfo = (IMappingInfo)this.getSqlRepository().getMappingInfos().get(className);
            sql = mappingInfo.getDeleteQuery();
            return this.objectCUDExecutor(obj, sql);
        }
        catch (Exception e) {
            throw this.processException("delete using object " + className + " defined table mapping", sql, e);
        }
    }

    public int remove(String queryId, Object[] values) throws QueryServiceException {
        IQueryInfo queryInfo = null;
        try {
            this.containesQueryId(queryId);
            queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
            return this.sqlCUDExecutor(queryInfo, values);
        }
        catch (Exception e) {
            throw this.processException("delete [query id = '" + queryId + "']", this.getQueryString(queryInfo), e);
        }
    }

    public int removeBySQL(String sql, String[] types, Object[] values) throws QueryServiceException {
        try {
            return this.sqlCUDExecutor(sql, values, this.convertTypes(types), false, null, null, null);
        }
        catch (Exception e) {
            throw this.processException("remove by SQL", sql, e);
        }
    }

    public int update(Object obj) throws QueryServiceException {
        String className = "";
        String sql = "";
        try {
            className = obj.getClass().getName();
            IMappingInfo mappingInfo = (IMappingInfo)this.getSqlRepository().getMappingInfos().get(className);
            sql = mappingInfo.getUpdateQuery();
            return this.objectCUDExecutor(obj, sql);
        }
        catch (Exception e) {
            throw this.processException("update using object " + className + " defined table mapping", sql, e);
        }
    }

    public int update(String queryId, Object[] values) throws QueryServiceException {
        IQueryInfo queryInfo = null;
        try {
            this.containesQueryId(queryId);
            queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
            return this.sqlCUDExecutor(queryInfo, values);
        }
        catch (Exception e) {
            throw this.processException("update [query id = '" + queryId + "']", this.getQueryString(queryInfo), e);
        }
    }

    public int updateBySQL(String sql, String[] types, Object[] values) throws QueryServiceException {
        try {
            return this.sqlCUDExecutor(sql, values, this.convertTypes(types), false, null, null, null);
        }
        catch (Exception e) {
            throw this.processException("update by SQL", sql, e);
        }
    }

    public int countQuery() {
        return this.getSqlRepository().countQuery();
    }

    public Map getQueryMap() throws QueryServiceException {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        try {
            Set keys = this.getSqlRepository().getQueryInfos().keySet();
            Iterator keyItr = keys.iterator();
            while (keyItr.hasNext()) {
                String queryId = (String)keyItr.next();
                IQueryInfo queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
                String statement = queryInfo.getQueryString();
                queryMap.put(queryId, statement);
            }
            return queryMap;
        }
        catch (Exception e) {
            throw new QueryServiceException(this.getMessageSource(), "error.query.get.querymap", new Object[0], e);
        }
    }

    public ArrayList getQueryParams(String queryId) throws QueryServiceException {
        try {
            IQueryInfo queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
            List paramList = queryInfo.getSqlParameterList();
            ArrayList<String[]> results = new ArrayList<String[]>();
            for (int i = 0; i < paramList.size(); ++i) {
                String[] params = new String[2];
                SqlParameter param = (SqlParameter)paramList.get(i);
                params[0] = param.getName();
                String paramTypeName = param.getTypeName();
                if (paramTypeName == null) {
                    int type = param.getSqlType();
                    paramTypeName = SQLTypeTransfer.getSQLTypeName(type);
                }
                params[1] = paramTypeName;
                results.add(params);
            }
            return results;
        }
        catch (Exception e) {
            throw new QueryServiceException(this.getMessageSource(), "error.query.common.checkparams", new Object[]{queryId}, e);
        }
    }

    public JdbcTemplate getQueryServiceJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public String getStatement(String queryId) throws QueryServiceException {
        IQueryInfo queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
        String sql = queryInfo.getQueryString();
        return sql;
    }

    public IQueryInfo getQueryInfo(String queryId) {
        return (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
    }

    protected int[] batchExecutor(String sql, int[] types, List targets) throws QueryServiceException {
        int i;
        if (targets.size() <= 0) {
            throw new QueryServiceException(this.getMessageSource(), "error.query.runtime.batch");
        }
        BatchSqlUpdate sqlBatch = new BatchSqlUpdate();
        sqlBatch.setJdbcTemplate((JdbcTemplate)this.jdbcTemplate);
        sqlBatch.setSql(sql);
        for (i = 0; types != null && i < types.length; ++i) {
            SqlParameter sp = new SqlParameter(types[i]);
            sqlBatch.declareParameter(sp);
        }
        sqlBatch.compile();
        for (i = 0; i < targets.size(); ++i) {
            Object obj = targets.get(i);
            if (!(obj instanceof Object[])) continue;
            sqlBatch.update((Object[])obj);
        }
        return sqlBatch.flush();
    }

    protected int[] batchDynamicExecutor(String sql, final List targets) {
        final ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return this.jdbcTemplate.batchUpdate(parsedSql.getNewSql(), new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return targets.size();
            }

            public void setValues(PreparedStatement ps, int index) throws SQLException {
                HashMap properties = new HashMap();
                properties.put("anyframe", targets.get(index));
                Object[] args = NamedParameterUtils.buildValueArray(parsedSql, new ExtMapSqlParameterSource(properties));
                for (int i = 0; i < args.length; ++i) {
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)Integer.MIN_VALUE, null, (Object)args[i]);
                }
            }
        });
    }

    protected int[] batchStaticExecutor(String sql, final List targets) {
        return this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

            public int getBatchSize() {
                return targets.size();
            }

            public void setValues(PreparedStatement ps, int index) throws SQLException {
                Object[] args = (Object[])targets.get(index);
                for (int i = 0; i < args.length; ++i) {
                    StatementCreatorUtils.setParameterValue((PreparedStatement)ps, (int)(i + 1), (int)Integer.MIN_VALUE, null, (Object)args[i]);
                }
            }
        });
    }

    protected int[] convertTypes(String[] types) {
        int[] iTypes = new int[types.length];
        for (int i = 0; i < types.length; ++i) {
            iTypes[i] = SQLTypeTransfer.getSQLType(types[i]);
        }
        return iTypes;
    }

    protected int objectCUDExecutor(Object obj, String sql) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("anyframe", obj);
        return this.namedJdbcTemplate.update(sql, new ExtMapSqlParameterSource(properties));
    }

    protected int sqlCUDExecutor(IQueryInfo queryInfo, Object[] values) throws Exception {
        int[] types = null;
        types = !queryInfo.isDynamic() ? queryInfo.getSqlTypes() : this.generateValueTypes(queryInfo, values);
        return this.sqlCUDExecutor(queryInfo.getQueryString(), values, types, queryInfo.isDynamic(), queryInfo.getLobStatement(), queryInfo.getLobParamTypes(), queryInfo.getQueryId());
    }

    protected int sqlCUDExecutor(String sql, Object[] values, int[] types, boolean isDynamic, String lobStatement, String[] lobParamTypes, String queryId) throws Exception {
        boolean hasLobStatement = false;
        Object[] inputValues = values;
        if (lobStatement != null) {
            hasLobStatement = true;
            if (!(values.length == 3 && values[0] instanceof Object[] && values[1] instanceof Object[] && values[2] instanceof Object[])) {
                throw new QueryServiceException(this.getMessageSource(), "error.query.get.lobvalues");
            }
            inputValues = (Object[])values[0];
        }
        ExtMapSqlParameterSource sqlParameterSource = null;
        if (isDynamic) {
            sqlParameterSource = new ExtMapSqlParameterSource();
            this.generatePropertiesMap(values, types, sqlParameterSource);
            sql = this.getRunnableSQL(sql, sqlParameterSource);
            if (this.isVelocity(sql)) {
                StringWriter writer = new StringWriter();
                Velocity.evaluate((Context)new ExtMapSqlParameterSourceContext(sqlParameterSource), (Writer)writer, (String)"QueryService", (String)sql);
                sql = writer.toString();
            }
        }
        if (hasLobStatement) {
            return this.jdbcTemplate.update(sql, inputValues, this.lobHandler, lobStatement, lobParamTypes, (Object[])values[1], (Object[])values[2]);
        }
        if (isDynamic) {
            return this.namedJdbcTemplate.update(sql, sqlParameterSource, this.lobHandler);
        }
        if (types == null) {
            return this.jdbcTemplate.update(sql, values);
        }
        return this.jdbcTemplate.update(sql, new PreparedStatementArgTypeSetter(values, types, this.lobHandler));
    }

    private Collection find(String queryId, Object[] values, int pageIndex, int pageSize, boolean paging) throws QueryServiceException {
        IQueryInfo queryInfo = null;
        try {
            this.containesQueryId(queryId);
            queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
            if (pageSize <= 0) {
                pageSize = this.getSqlRepository().getFetchCountPerQuery(queryId);
            }
            PaginationVO paginationVO = new PaginationVO(pageSize);
            paginationVO.setPaging(paging);
            paginationVO.setPageIndex(pageIndex);
            return this.findInternal(queryInfo, queryId, values, paginationVO, paging, null);
        }
        catch (Exception e) {
            throw this.processException("execute statement [query id = '" + queryId + "']", this.getQueryString(queryInfo), e);
        }
    }

    private Map findWithRowCount(String queryId, Object[] values, int pageIndex, int pageSize, boolean paging) throws QueryServiceException {
        IQueryInfo queryInfo = null;
        try {
            this.containesQueryId(queryId);
            queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
            if (pageSize == -1) {
                pageSize = this.getSqlRepository().getFetchCountPerQuery(queryId);
            }
            PaginationVO paginationVO = new PaginationVO(pageSize);
            paginationVO.setPaging(paging);
            paginationVO.setPageIndex(pageIndex);
            paginationVO.setCountRecordSize(true);
            List list = this.findInternal(queryInfo, queryId, values, paginationVO, paging, null);
            long count = 0L;
            count = !paging ? (long)list.size() : paginationVO.getRecordCount();
            return this.makeResultMap(list, count, null);
        }
        catch (Exception e) {
            throw this.processException("select by paging [query id = '" + queryId + "']", this.getQueryString(queryInfo), e);
        }
    }

    private Map findWithColInfo(String queryId, Object[] values, int pageIndex, int pageSize, boolean paging) throws QueryServiceException {
        IQueryInfo queryInfo = null;
        try {
            this.containesQueryId(queryId);
            queryInfo = (IQueryInfo)this.getSqlRepository().getQueryInfos().get(queryId);
            if (pageSize == -1) {
                pageSize = this.getSqlRepository().getFetchCountPerQuery(queryId);
            }
            PaginationVO paginationVO = new PaginationVO(pageSize);
            paginationVO.setPaging(paging);
            paginationVO.setPageIndex(pageIndex);
            paginationVO.setCountRecordSize(true);
            CallbackResultSetMapper rowCallbackHandler = this.createResultSetMapper(queryInfo, this.lobHandler, this.getSqlRepository().getNullCheck());
            List resultList = this.findInternal(queryInfo, queryId, values, paginationVO, paging, rowCallbackHandler);
            long count = 0L;
            count = !paging ? (long)resultList.size() : paginationVO.getRecordCount();
            return this.makeResultMap(resultList, count, rowCallbackHandler.getColumnInfo());
        }
        catch (Exception e) {
            throw this.processException("select with column info [query id = '" + queryId + "']", this.getQueryString(queryInfo), e);
        }
    }

    private String getQueryString(IQueryInfo queryInfo) {
        String sql = "";
        if (queryInfo != null) {
            sql = queryInfo.getQueryString();
        }
        return sql;
    }

    private List findInternal(IQueryInfo queryInfo, String queryId, Object[] values, PaginationVO paginationVO, boolean paging, CallbackResultSetMapper resultSetMapper) throws QueryServiceException {
        String sql = "";
        try {
            sql = queryInfo.getQueryString();
            boolean isDynamic = queryInfo.isDynamic();
            if (resultSetMapper == null) {
                resultSetMapper = this.createResultSetMapper(queryInfo, this.lobHandler, this.getSqlRepository().getNullCheck());
            }
            if (isDynamic) {
                ExtMapSqlParameterSource sqlParameterSource;
                Map properties = this.generatePropertiesMap(values, null, null);
                if (properties == null) {
                    properties = new Properties();
                }
                if (this.isVelocity(sql = this.getRunnableSQL(sql, sqlParameterSource = new ExtMapSqlParameterSource(properties)))) {
                    StringWriter writer = new StringWriter();
                    Velocity.evaluate((Context)new ExtMapSqlParameterSourceContext(sqlParameterSource), (Writer)writer, (String)"QueryService", (String)sql);
                    sql = writer.toString();
                }
                this.namedJdbcTemplate.query(sql, sqlParameterSource, resultSetMapper, paginationVO);
                return resultSetMapper.getObjects();
            }
            if (!paging) {
                return this.jdbcTemplate.query(sql, values, queryInfo.getSqlTypes(), resultSetMapper);
            }
            return this.jdbcTemplate.queryWithPagination(sql, values, queryInfo.getSqlTypes(), resultSetMapper, paginationVO);
        }
        catch (Exception e) {
            throw this.processException("select [query id = '" + queryId + "']", sql, e);
        }
    }

    private CallbackResultSetMapper createResultSetMapper(IQueryInfo queryInfo, LobHandler lobHandler, Map nullchecks) throws Exception {
        Class targetClazz = null;
        IResultSetMapper customResultSetMapper = null;
        if (queryInfo.doesNeedColumnMapping()) {
            targetClazz = Thread.currentThread().getContextClassLoader().loadClass(queryInfo.getResultClass());
        } else if (queryInfo.getResultMapper() != null) {
            if (IResultSetMapper.class.isAssignableFrom(targetClazz = Thread.currentThread().getContextClassLoader().loadClass(queryInfo.getResultMapper()))) {
                customResultSetMapper = (IResultSetMapper)targetClazz.newInstance();
            }
        } else {
            targetClazz = HashMap.class;
        }
        IMappingInfo mappingInfo = this.getSqlRepository().getMappingInfo(queryInfo.getQueryId());
        CallbackResultSetMapper callbackResultSetMapper = new CallbackResultSetMapper(targetClazz, mappingInfo, lobHandler, nullchecks, queryInfo.getMappingStyle());
        if (customResultSetMapper != null) {
            callbackResultSetMapper.setCustomResultSetMapper(customResultSetMapper);
        }
        return callbackResultSetMapper;
    }

    private int[] generateValueTypes(IQueryInfo queryInfo, Object[] values) throws QueryServiceException {
        int[] types = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            String tempStr = null;
            Object[] tempArray = null;
            if (values[i] instanceof String) {
                tempStr = (String)values[i];
                int pos = tempStr.indexOf(DELIMETER);
                if (pos < 0) {
                    throw new QueryServiceException(this.getMessageSource(), "error.query.generate.valuemap.string");
                }
                types[i] = queryInfo.getSqlType(tempStr.substring(0, pos));
                continue;
            }
            if (values[i] instanceof Object[]) {
                tempArray = (Object[])values[i];
                if (tempArray.length != 2) {
                    throw new QueryServiceException(this.getMessageSource(), "error.query.generate.valuemap.array");
                }
                types[i] = queryInfo.getSqlType((String)tempArray[0]);
                continue;
            }
            types[i] = values[i] == null ? Integer.MIN_VALUE : Integer.MIN_VALUE;
        }
        return types;
    }

    private Map generatePropertiesMap(Object[] values, int[] types, MapSqlParameterSource mapSqlParameterSource) throws QueryServiceException {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        String tempStr = null;
        Object[] tempArray = null;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof String) {
                tempStr = (String)values[i];
                int pos = tempStr.indexOf(DELIMETER);
                if (pos < 0) {
                    throw new QueryServiceException(this.getMessageSource(), "error.query.generate.valuemap.string");
                }
                properties.put(tempStr.substring(0, pos), tempStr.substring(pos + 1));
                if (mapSqlParameterSource == null) continue;
                mapSqlParameterSource.addValue(tempStr.substring(0, pos), (Object)tempStr.substring(pos + 1), types[i]);
                continue;
            }
            if (values[i] instanceof Object[]) {
                tempArray = (Object[])values[i];
                if (tempArray.length != 2) {
                    throw new QueryServiceException(this.getMessageSource(), "error.query.generate.valuemap.array");
                }
                properties.put(tempArray[0], tempArray[1]);
                if (mapSqlParameterSource == null) continue;
                mapSqlParameterSource.addValue((String)tempArray[0], tempArray[1], types[i]);
                continue;
            }
            if (values[i] == null) continue;
            return null;
        }
        return properties;
    }

    private HashMap makeResultMap(List resultList, long totalCount, Map columnInfo) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("LIST", resultList);
        result.put("COUNT", new Long(totalCount));
        if (columnInfo != null) {
            result.put("COLUMN_INFO", columnInfo);
        }
        return result;
    }

    public QueryServiceException processException(String actionName, String sql, Exception exception) {
        IQueryService.LOGGER.error((Object)this.getMessageSource().getMessage("error.query.runtime.error", new Object[]{actionName, sql, exception.getMessage()}, Locale.getDefault()), (Throwable)exception);
        if (exception instanceof InternalDataAccessException) {
            InternalDataAccessException idaException = (InternalDataAccessException)((Object)exception);
            QueryServiceException queryServiceException = new QueryServiceException(this.getMessageSource(), "error.query.runtime.error", new Object[]{actionName, sql, exception.getMessage()}, (Throwable)((Object)idaException));
            queryServiceException.setSqlErrorCode(idaException.getSqlErrorCode());
            queryServiceException.setSqlErrorMessage(idaException.getSqlErrorMessage());
            return queryServiceException;
        }
        if (exception instanceof QueryServiceException) {
            return (QueryServiceException)((Object)exception);
        }
        return new QueryServiceException(this.getMessageSource(), "error.query.runtime.error", new Object[]{actionName, sql, exception.getMessage()}, exception);
    }
}

