/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.config.loader;

import anyframe.core.query.IMappingInfo;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class MappingInfo
implements IMappingInfo {
    private String className = null;
    private String tableName = null;
    private String[] columnNames = new String[0];
    private String[] fieldNames = new String[0];
    private Map compositeColumnNames = new HashMap();
    private Map compositeFieldNames = new HashMap();
    private String[] primaryKeyColumns = new String[0];
    private String selectByPrimaryKeyQuery = null;
    private String insertQuery = null;
    private String deleteQuery = null;
    private String updateQuery = null;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.className = configuration.getAttribute("class", null);
        if (configuration.getAttribute("name", "").equals("")) {
            throw new ConfigurationException("Query Service : name is essential attribute in a <table>.");
        }
        this.tableName = configuration.getAttribute("name");
        Configuration[] mappings = configuration.getChildren("field-mapping");
        if (mappings.length == 0) {
            throw new ConfigurationException("Query Service : must have <field-mapping> over one in a <table>.");
        }
        this.columnNames = new String[mappings.length];
        this.fieldNames = new String[mappings.length];
        for (int k = 0; k < mappings.length; ++k) {
            this.columnNames[k] = mappings[k].getChild("dbms-column").getValue();
            this.fieldNames[k] = mappings[k].getChild("class-attribute").getValue();
        }
        Configuration[] primarykeysConfig = configuration.getChild("primary-key").getChildren("dbms-column");
        this.primaryKeyColumns = new String[primarykeysConfig.length];
        for (int k = 0; k < primarykeysConfig.length; ++k) {
            this.primaryKeyColumns[k] = primarykeysConfig[k].getValue();
        }
    }

    public String getSelectByPrimaryKeyQuery() {
        if (this.selectByPrimaryKeyQuery == null) {
            int i;
            StringBuffer sql = new StringBuffer("SELECT ");
            int size = this.columnNames.length;
            for (i = 0; i < size; ++i) {
                sql.append(this.columnNames[i]);
                if (i >= size - 1) continue;
                sql.append(" , ");
            }
            sql.append(" FROM ");
            sql.append(this.tableName);
            if (this.primaryKeyColumns.length > 0) {
                sql.append(" WHERE ");
                size = this.primaryKeyColumns.length;
                for (i = 0; i < size; ++i) {
                    if (i != 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.primaryKeyColumns[i]);
                    sql.append(" = :anyframe." + this.getFieldNameCorrespondingToColumnName(this.primaryKeyColumns[i]));
                }
            }
            this.selectByPrimaryKeyQuery = sql.toString();
        }
        return this.selectByPrimaryKeyQuery;
    }

    public String getInsertQuery() {
        if (this.insertQuery == null) {
            int i;
            StringBuffer sql = new StringBuffer("INSERT INTO " + this.tableName + " (");
            int size = this.columnNames.length;
            for (i = 0; i < size; ++i) {
                sql.append(this.columnNames[i]);
                if (i >= size - 1) continue;
                sql.append(" , ");
            }
            sql.append(" ) ");
            sql.append(" VALUES ( ");
            size = this.columnNames.length;
            for (i = 0; i < size; ++i) {
                sql.append(" :anyframe." + this.getFieldNameCorrespondingToColumnName(this.columnNames[i]));
                if (i == size - 1) continue;
                sql.append(" , ");
            }
            sql.append(" ) ");
            this.insertQuery = sql.toString();
        }
        return this.insertQuery;
    }

    public String getUpdateQuery() {
        if (this.updateQuery == null) {
            int i;
            StringBuffer sql = new StringBuffer("UPDATE " + this.tableName + " SET ");
            int size = this.columnNames.length;
            for (i = 0; i < size; ++i) {
                sql.append(this.columnNames[i]);
                sql.append(" = ");
                sql.append(" :anyframe." + this.getFieldNameCorrespondingToColumnName(this.columnNames[i]));
                if (i >= size - 1) continue;
                sql.append(" , ");
            }
            if (this.primaryKeyColumns.length > 0) {
                sql.append(" WHERE ");
                size = this.primaryKeyColumns.length;
                for (i = 0; i < size; ++i) {
                    if (i != 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.primaryKeyColumns[i]);
                    sql.append(" = :anyframe." + this.getFieldNameCorrespondingToColumnName(this.primaryKeyColumns[i]));
                }
            }
            this.updateQuery = sql.toString();
        }
        return this.updateQuery;
    }

    public String getDeleteQuery() {
        if (this.deleteQuery == null) {
            StringBuffer sql = new StringBuffer("DELETE ");
            sql.append(" FROM ");
            sql.append(this.tableName);
            if (this.primaryKeyColumns.length > 0) {
                sql.append(" WHERE ");
                int size = this.primaryKeyColumns.length;
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.primaryKeyColumns[i]);
                    sql.append(" = :anyframe." + this.getFieldNameCorrespondingToColumnName(this.primaryKeyColumns[i]));
                }
            }
            this.deleteQuery = sql.toString();
        }
        return this.deleteQuery;
    }

    protected String getFieldNameCorrespondingToColumnName(String columnName) {
        int size = this.columnNames.length;
        for (int i = 0; i < size; ++i) {
            if (!this.columnNames[i].equals(columnName)) continue;
            return this.fieldNames[i];
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public String[] getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public void setFieldNames(String[] fieldNames) {
        this.fieldNames = fieldNames;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map getMappingInfoAsMap() {
        HashMap<String, String> rtMap = new HashMap<String, String>();
        int size = this.columnNames.length;
        for (int i = 0; i < size; ++i) {
            rtMap.put(this.columnNames[i], this.fieldNames[i]);
        }
        return rtMap;
    }

    public Map getCompositeColumnNames() {
        return this.compositeColumnNames;
    }

    public void setCompositeColumnNames(Map compositeColumnNames) {
        this.compositeColumnNames = compositeColumnNames;
    }

    public Map getCompositeFieldNames() {
        return this.compositeFieldNames;
    }

    public void setCompositeFieldNames(Map compositeFieldNames) {
        this.compositeFieldNames = compositeFieldNames;
    }
}

