/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.config.loader;

import anyframe.core.query.IQueryInfo;
import anyframe.core.query.IQueryService;
import anyframe.core.query.impl.config.loader.MappingInfo;
import anyframe.core.query.impl.util.SQLTypeTransfer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.springframework.util.StringUtils;

public class QueryInfo
implements IQueryInfo {
    protected static final String PROPERTY_NOT_SETTING = "";
    protected static final String CAMEL_CASE = "camel";
    protected static final String LOWER_CASE = "lower";
    private String queryId = null;
    private String queryString = null;
    private String resultClass = null;
    private String resultMapper = null;
    private MappingInfo localMappingInfo = null;
    private boolean isDynamic = true;
    private boolean isCamelCase = true;
    private String lobStatement = null;
    private String[] lobParamTypes = null;
    private int length = 0;
    private String mappingStyle = null;
    private String[] paramTypeNames = null;
    private String[] paramBindingTypes = null;
    private String[] paramBindingNames = null;
    private List sqlParameterList = null;
    private Map paramMap = new HashMap();

    public void configure(Configuration queryConfig) throws ConfigurationException {
        this.queryId = queryConfig.getAttribute("id", PROPERTY_NOT_SETTING);
        if (this.queryId.equals(PROPERTY_NOT_SETTING)) {
            throw new ConfigurationException("Query Service : id is essential attribute in a <query>.");
        }
        this.queryString = queryConfig.getChild("statement").getValue();
        this.isDynamic = queryConfig.getAttributeAsBoolean("isDynamic", true);
        this.isCamelCase = queryConfig.getAttributeAsBoolean("isCamelCase", true);
        this.mappingStyle = queryConfig.getAttribute("mappingStyle", null);
        this.checkMappingStyle();
        Configuration results = queryConfig.getChild("result", false);
        if (results != null) {
            this.resultClass = results.getAttribute("class", null);
            this.resultMapper = results.getAttribute("mapper", null);
            this.length = results.getAttributeAsInteger("length", 0);
            Configuration[] resultMappings = results.getChildren("result-mapping");
            if (resultMappings.length > 0) {
                this.localMappingInfo = new MappingInfo();
                Object[] columns = new String[resultMappings.length];
                Object[] fieldes = new String[resultMappings.length];
                Arrays.fill(columns, PROPERTY_NOT_SETTING);
                Arrays.fill(fieldes, PROPERTY_NOT_SETTING);
                HashMap<String, String[]> compositeColumnMap = new HashMap<String, String[]>();
                HashMap<String, String[]> compositeFieldMap = new HashMap<String, String[]>();
                for (int i = 0; i < resultMappings.length; ++i) {
                    String column = resultMappings[i].getAttribute("column");
                    String field = resultMappings[i].getAttribute("attribute");
                    if (this.isComposite(column) && this.isComposite(field)) {
                        String[] compositeFieldes;
                        column = column.substring(1, column.length() - 1);
                        field = field.substring(1, field.length() - 1);
                        String[] compositeColumns = StringUtils.trimAllWhitespace((String)column).split(",");
                        if (compositeColumns.length == (compositeFieldes = StringUtils.trimAllWhitespace((String)field).split(",")).length) {
                            String compositeField = PROPERTY_NOT_SETTING;
                            for (int j = 0; j < compositeFieldes.length; ++j) {
                                String compositeFieldName = compositeFieldes[j];
                                String tempField = compositeFieldName.substring(0, compositeFieldName.indexOf("."));
                                if (i != 0 && !tempField.equals(compositeField)) {
                                    IQueryService.LOGGER.warn((Object)("Query Service : This mapping information is ignored. Property name is different. If you want to handle properties of user defined type, attribute should start with same property name. Please check result mapping (queryId ='" + this.queryId + "')"));
                                }
                                compositeField = tempField;
                                compositeFieldes[j] = compositeFieldName.substring(compositeFieldName.indexOf(".") + 1);
                            }
                            compositeFieldMap.put(compositeField, compositeFieldes);
                            compositeColumnMap.put(compositeField, compositeColumns);
                            continue;
                        }
                        IQueryService.LOGGER.warn((Object)("Query Service : This mapping information is ignored. If you want to handle properties of user defined type, the number of column should be same as that of attribute. Please check result mapping (queryId ='" + this.queryId + "')"));
                        continue;
                    }
                    columns[i] = column;
                    fieldes[i] = field;
                }
                this.localMappingInfo.setColumnNames((String[])columns);
                this.localMappingInfo.setFieldNames((String[])fieldes);
                this.localMappingInfo.setCompositeColumnNames(compositeColumnMap);
                this.localMappingInfo.setCompositeFieldNames(compositeFieldMap);
            }
        }
        Configuration[] params = queryConfig.getChildren("param");
        this.paramTypeNames = new String[params.length];
        this.paramBindingTypes = new String[params.length];
        this.paramBindingNames = new String[params.length];
        int size = params.length;
        for (int i = 0; i < size; ++i) {
            this.paramTypeNames[i] = params[i].getAttribute("type");
            this.paramBindingTypes[i] = params[i].getAttribute("binding", PROPERTY_NOT_SETTING);
            this.paramBindingNames[i] = params[i].getAttribute("name", PROPERTY_NOT_SETTING);
            if (!this.isDynamic()) continue;
            this.paramMap.put(this.paramBindingNames[i], new Integer(SQLTypeTransfer.getSQLType(this.paramTypeNames[i].toUpperCase())));
        }
        Configuration lobConfig = queryConfig.getChild("lobStatement");
        this.lobStatement = lobConfig.getChild("statement").getValue(null);
        Configuration[] lobParams = lobConfig.getChildren("param");
        this.lobParamTypes = new String[lobParams.length];
        for (int i = 0; i < lobParams.length; ++i) {
            this.lobParamTypes[i] = lobParams[i].getAttribute("type");
        }
    }

    private void checkMappingStyle() {
        if (this.mappingStyle == null) {
            this.mappingStyle = this.isCamelCase ? CAMEL_CASE : LOWER_CASE;
        }
    }

    private boolean isComposite(String str) {
        return str.startsWith("{") && str.endsWith("}");
    }

    public List getSqlParameterList() {
        if (this.sqlParameterList == null) {
            this.sqlParameterList = SQLTypeTransfer.getSqlParameterList(this.paramTypeNames, this.paramBindingTypes, this.paramBindingNames);
        }
        return this.sqlParameterList;
    }

    public int[] getSqlTypes() {
        int[] types = new int[this.paramTypeNames.length];
        for (int i = 0; i < this.paramTypeNames.length; ++i) {
            types[i] = this.getSqlType(i);
        }
        return types;
    }

    public int getSqlType(int pos) {
        if (pos < this.paramTypeNames.length) {
            return SQLTypeTransfer.getSQLType(this.paramTypeNames[pos].toUpperCase());
        }
        return Integer.MIN_VALUE;
    }

    public int getSqlType(String paramTypeName) {
        Integer sqlType = (Integer)this.paramMap.get(paramTypeName);
        if (sqlType == null) {
            return Integer.MIN_VALUE;
        }
        return sqlType;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getResultClass() {
        return this.resultClass;
    }

    public boolean doesNeedColumnMapping() {
        return this.resultClass != null;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public int getFetchCountPerQuery() {
        return this.length;
    }

    public String getMappingStyle() {
        return this.mappingStyle;
    }

    public MappingInfo getLocalMappingInfo() {
        return this.localMappingInfo;
    }

    public String[] getParamBindingNames() {
        return this.paramBindingNames;
    }

    public void setParamBindingNames(String[] paramBindingNames) {
        this.paramBindingNames = paramBindingNames;
    }

    public String getLobStatement() {
        return this.lobStatement;
    }

    public String[] getLobParamTypes() {
        return this.lobParamTypes;
    }

    public String getResultMapper() {
        return this.resultMapper;
    }
}

