/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.config.loader;

import anyframe.common.util.StringUtil;
import anyframe.core.query.IMappingInfo;
import anyframe.core.query.IQueryInfo;
import anyframe.core.query.IQueryService;
import anyframe.core.query.QueryServiceException;
import anyframe.core.query.impl.config.BeansDtdResolver;
import anyframe.core.query.impl.config.loader.MappingInfo;
import anyframe.core.query.impl.config.loader.QueryInfo;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ResourceUtils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class SQLLoader
implements Configurable,
MessageSourceAware,
ResourceLoaderAware,
InitializingBean,
DisposableBean {
    private boolean skipError = false;
    private Watcher watcher;
    private MessageSource messageSource;
    private ResourceLoader resourceLoader = null;
    private HashMap nullchecks = new HashMap();
    private Configuration configuration = null;
    private Map queryInfos = new HashMap();
    private Map mappingInfos = new HashMap();
    private int registeredQueryCount = 0;

    public abstract void setConfiguration(Configuration var1);

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.configSkipErrorInfo();
            this.configNullCheckInfos();
            boolean dynamicSqlLoad = this.setUpWatcher();
            DefaultConfigurationBuilder builder = this.getBuilder();
            this.loadSQLDefinitions(builder, dynamicSqlLoad);
        }
        catch (Exception e) {
            IQueryService.LOGGER.error((Object)this.messageSource.getMessage("error.query.initialize.configure", (Object[])new String[0], Locale.getDefault()), (Throwable)e);
            throw new ConfigurationException("Query Service : Fail to configure mapping xml files.", (Throwable)e);
        }
        IQueryService.LOGGER.info((Object)("Query Service : There are " + this.registeredQueryCount + " defined queries in all configuration files."));
    }

    public Map getQueryInfos() {
        return this.queryInfos;
    }

    public Map getMappingInfos() {
        return this.mappingInfos;
    }

    public IMappingInfo getMappingInfo(String queryId) {
        if (!this.hasQuery(queryId)) {
            return null;
        }
        final QueryInfo queryInfo = (QueryInfo)this.queryInfos.get(queryId);
        MappingInfo mappingInfo = queryInfo.getLocalMappingInfo();
        String resultClass = queryInfo.getResultClass();
        if (mappingInfo != null) {
            return mappingInfo;
        }
        mappingInfo = (MappingInfo)this.mappingInfos.get(resultClass);
        if (resultClass == null || mappingInfo == null) {
            return new IMappingInfo(){

                public String getInsertQuery() {
                    return null;
                }

                public String getDeleteQuery() {
                    return null;
                }

                public Map getCompositeColumnNames() {
                    return null;
                }

                public Map getCompositeFieldNames() {
                    return null;
                }

                public Map getMappingInfoAsMap() {
                    return new Map(){

                        public void clear() {
                        }

                        public boolean containsKey(Object key) {
                            return true;
                        }

                        public boolean containsValue(Object value) {
                            return true;
                        }

                        public Set entrySet() {
                            return null;
                        }

                        public Object get(Object key) {
                            if (queryInfo.getMappingStyle().equals("camel")) {
                                return StringUtil.convertToCamelCase((String)((String)key));
                            }
                            if (queryInfo.getMappingStyle().equals("lower")) {
                                return ((String)key).toLowerCase();
                            }
                            if (queryInfo.getMappingStyle().equals("upper")) {
                                return ((String)key).toUpperCase();
                            }
                            return (String)key;
                        }

                        public boolean isEmpty() {
                            return false;
                        }

                        public Set keySet() {
                            return null;
                        }

                        public Object put(Object key, Object value) {
                            return null;
                        }

                        public void putAll(Map t) {
                        }

                        public Object remove(Object key) {
                            return null;
                        }

                        public int size() {
                            return 0;
                        }

                        public Collection values() {
                            return null;
                        }
                    };
                }

                public String[] getPrimaryKeyColumns() {
                    return null;
                }

                public String getSelectByPrimaryKeyQuery() {
                    return null;
                }

                public String getTableName() {
                    return null;
                }

                public String getClassName() {
                    return null;
                }

                public String getUpdateQuery() {
                    return null;
                }
            };
        }
        return mappingInfo;
    }

    public boolean hasQuery(String queryId) {
        return this.queryInfos.get(queryId) != null;
    }

    public String getQueryStatement(String queryId) {
        return ((IQueryInfo)this.queryInfos.get(queryId)).getQueryString();
    }

    public boolean isDynamicQueryStatement(String queryId) {
        return ((IQueryInfo)this.queryInfos.get(queryId)).isDynamic();
    }

    public int countQuery() {
        return this.registeredQueryCount;
    }

    public int getFetchCountPerQuery(String queryId) {
        return ((IQueryInfo)this.queryInfos.get(queryId)).getFetchCountPerQuery();
    }

    public String getTableFromClassName(String className) {
        return ((IMappingInfo)this.mappingInfos.get(className)).getTableName();
    }

    public HashMap getNullCheck() {
        return this.nullchecks;
    }

    public String[] getPrimaryKeysFromClassName(String className) {
        return ((IMappingInfo)this.mappingInfos.get(className)).getPrimaryKeyColumns();
    }

    private void configSkipErrorInfo() {
        if (this.configuration.getChild("skiperror") != null) {
            this.skipError = this.configuration.getChild("skiperror").getValueAsBoolean(false);
        }
    }

    private void configNullCheckInfos() throws ConfigurationException {
        Configuration[] nullChecksConfig = this.configuration.getChildren("nullcheck");
        for (int i = 0; i < nullChecksConfig.length; ++i) {
            String type = nullChecksConfig[i].getAttribute("type", null);
            String defaultValue = nullChecksConfig[i].getAttribute("default-value");
            if (type == null) continue;
            this.nullchecks.put(type.toLowerCase(), defaultValue);
        }
    }

    private boolean setUpWatcher() {
        boolean dynamicSqlLoad = false;
        int frequency = 5;
        Configuration sqlLoadConfig = this.configuration.getChild("sqlload");
        if (sqlLoadConfig != null) {
            dynamicSqlLoad = sqlLoadConfig.getAttributeAsBoolean("dynamic", false);
            frequency = sqlLoadConfig.getAttributeAsInteger("frequency", 5);
        }
        if (dynamicSqlLoad) {
            this.watcher = new Watcher(this);
            this.watcher.setRefreshRate(frequency);
        }
        return dynamicSqlLoad;
    }

    private DefaultConfigurationBuilder getBuilder() throws QueryServiceException, ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(false);
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader parser = saxParser.getXMLReader();
        parser.setEntityResolver(new BeansDtdResolver());
        return new DefaultConfigurationBuilder(parser);
    }

    private void loadSQLDefinitions(DefaultConfigurationBuilder builder, boolean dynamicSqlLoad) throws Exception {
        Configuration[] files = this.configuration.getChildren("filename");
        String location = "";
        for (int i = 0; i < files.length; ++i) {
            int loadCount;
            location = files[i].getValue();
            if (this.resourceLoader instanceof ResourcePatternResolver) {
                try {
                    Resource[] resources = ((ResourcePatternResolver)this.resourceLoader).getResources(location);
                    loadCount = this.loadSQLDefinitions(builder, dynamicSqlLoad, resources);
                    if (!IQueryService.LOGGER.isDebugEnabled()) continue;
                    IQueryService.LOGGER.debug((Object)("Loaded " + loadCount + " sql definitions from location pattern [" + location + "]"));
                    continue;
                }
                catch (IOException ex) {
                    throw new ConfigurationException("Query Service : Could not resolve sql definition resource pattern [" + location + "]", (Throwable)ex);
                }
            }
            Resource resource = this.resourceLoader.getResource(location);
            loadCount = this.loadSQLDefinitions(builder, dynamicSqlLoad, new Resource[]{resource});
            if (!IQueryService.LOGGER.isDebugEnabled()) continue;
            IQueryService.LOGGER.debug((Object)("Loaded " + loadCount + " sql definitions from location [" + location + "]"));
        }
        if (dynamicSqlLoad) {
            this.watcher.start();
            if (IQueryService.LOGGER.isDebugEnabled()) {
                IQueryService.LOGGER.debug((Object)"Query Service : Watcher is started...");
            }
        }
    }

    private void addToWatcher(boolean dynamicSqlLoad, Resource resource) throws Exception {
        if (dynamicSqlLoad && !ResourceUtils.isJarURL((URL)resource.getURL())) {
            this.watcher.addResource(resource);
        }
    }

    private int loadSQLDefinitions(DefaultConfigurationBuilder builder, boolean dynamicSqlLoad, Resource[] resources) throws Exception {
        int loadCount = 0;
        for (int i = 0; i < resources.length; ++i) {
            loadCount += this.buildSQLMap(builder, resources[i]);
            this.addToWatcher(dynamicSqlLoad, resources[i]);
        }
        return loadCount;
    }

    private int buildSQLMap(DefaultConfigurationBuilder builder, Resource resource) throws ConfigurationException, SAXException, IOException {
        int successCount;
        block5: {
            successCount = 0;
            try {
                Configuration rootConfig = builder.build(resource.getInputStream());
                Configuration[] configs = rootConfig.getChildren();
                int size = configs.length;
                for (int i = 0; i < size; ++i) {
                    Configuration config = configs[i];
                    Configuration[] querys = config.getChildren("query");
                    for (int j = 0; j < querys.length; ++j) {
                        QueryInfo queryInfo = new QueryInfo();
                        queryInfo.configure(querys[j]);
                        this.queryInfos.put(queryInfo.getQueryId(), queryInfo);
                        ++successCount;
                        ++this.registeredQueryCount;
                    }
                    Configuration[] tables = config.getChildren("table");
                    for (int j = 0; j < tables.length; ++j) {
                        MappingInfo mappingInfo = new MappingInfo();
                        mappingInfo.configure(tables[j]);
                        this.mappingInfos.put(mappingInfo.getClassName(), mappingInfo);
                    }
                }
            }
            catch (SAXParseException se) {
                IQueryService.LOGGER.error((Object)("Query Service : Fail to configure mapping xml file [" + resource.getFilename() + "]. " + se.getSystemId() + " is invalid.\n" + "Cause - [" + se.getMessage() + "]\n" + "Please confirm the " + se.getLineNumber() + " line in " + se.getSystemId() + "."), (Throwable)se);
                if (this.skipError) break block5;
                throw se;
            }
        }
        return successCount;
    }

    public void destroy() throws QueryServiceException {
        this.clearSQLMap();
        this.nullchecks.clear();
        if (this.watcher != null) {
            this.watcher.setDone();
        }
    }

    private void clearSQLMap() {
        this.queryInfos.clear();
        this.mappingInfos.clear();
        this.registeredQueryCount = 0;
    }

    class Watcher
    extends Thread {
        private final int scanRate = 10;
        private Hashtable resources = new Hashtable();
        private boolean done = false;
        private long refreshRate = 0L;

        public Watcher(Object subscriber) {
            this.setDaemon(true);
            this.setPriority(1);
        }

        public void setRefreshRate(long refresh) {
            this.refreshRate = refresh > 10L ? refresh : 10L;
        }

        public long getRefreshRate() {
            return this.refreshRate;
        }

        public void addResource(Resource resource) throws Exception {
            this.resources.put(resource, new Long(resource.getFile().lastModified()));
            IQueryService.LOGGER.info((Object)("appended " + resource.getFilename() + " file for monitoring"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (!this.done) {
                    Watcher watcher = this;
                    synchronized (watcher) {
                        boolean modificationChk = false;
                        Enumeration en = this.resources.keys();
                        while (en.hasMoreElements()) {
                            try {
                                Resource resource = (Resource)en.nextElement();
                                long modified = (Long)this.resources.get(resource);
                                if (!resource.exists()) {
                                    this.resources.remove(resource);
                                    continue;
                                }
                                if (resource.getFile().getAbsoluteFile().lastModified() <= modified) continue;
                                this.resources.put(resource, new Long(resource.getFile().lastModified()));
                                modificationChk = true;
                            }
                            catch (Exception e) {
                                IQueryService.LOGGER.error((Object)"Query Service : Fail to check whether mapping XML file is modified.", (Throwable)e);
                            }
                        }
                        try {
                            if (modificationChk) {
                                this.rebuildSQLMap(SQLLoader.this.getBuilder());
                            }
                        }
                        catch (Exception e) {
                            IQueryService.LOGGER.error((Object)"Query Service : Fail to rebuild Query Mapping.", (Throwable)e);
                        }
                        Watcher.sleep(this.getRefreshRate());
                    }
                }
                return;
            }
            catch (InterruptedException e) {
                IQueryService.LOGGER.error((Object)"Query Service : Fail to run Watcher.", (Throwable)e);
            }
        }

        private void rebuildSQLMap(DefaultConfigurationBuilder builder) throws QueryServiceException {
            IQueryService.LOGGER.info((Object)"Query Service : Watcher rebuilds Query Mapping.....");
            SQLLoader.this.clearSQLMap();
            Enumeration en = this.resources.keys();
            while (en.hasMoreElements()) {
                Resource resource = (Resource)en.nextElement();
                try {
                    SQLLoader.this.buildSQLMap(builder, resource);
                }
                catch (Exception e) {
                    IQueryService.LOGGER.error((Object)("Query Service : Error Query Mapping file : " + resource.getFilename()), (Throwable)e);
                }
                IQueryService.LOGGER.info((Object)("Query Service : Rebuild Query Mapping file : " + resource.getFilename()));
            }
        }

        public void setDone() {
            this.done = true;
        }
    }
}

