/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc;

import anyframe.core.query.IQueryService;
import anyframe.core.query.impl.jdbc.PagingJdbcTemplate;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import net.sf.log4jdbc.PreparedStatementSpy;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.InterruptibleBatchPreparedStatementSetter;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;

public class OraclePagingJdbcTemplate
extends PagingJdbcTemplate {
    private NativeJdbcExtractor nativeJdbcExtractor;

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public int[] batchUpdate(String sql, final BatchPreparedStatementSetter pss) throws DataAccessException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Executing SQL batch update [" + sql + "]"));
        }
        return (int[])this.execute(sql, new PreparedStatementCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInPreparedStatement(PreparedStatement ps) throws SQLException {
                try {
                    int batchSize = pss.getBatchSize();
                    if (JdbcUtils.supportsBatchUpdates((Connection)ps.getConnection())) {
                        OraclePagingJdbcTemplate.this.logger.debug((Object)"Oracle JDBC driver");
                        if (OraclePagingJdbcTemplate.this.nativeJdbcExtractor != null) {
                            ps = OraclePagingJdbcTemplate.this.nativeJdbcExtractor.getNativePreparedStatement(ps);
                        }
                        if (ps instanceof PreparedStatementSpy) {
                            ps = ((PreparedStatementSpy)ps).getRealPreparedStatement();
                        }
                        try {
                            Method setExecuteBatchMethod = ps.getClass().getMethod("setExecuteBatch", Integer.TYPE);
                            setExecuteBatchMethod.invoke((Object)ps, new Integer(batchSize));
                        }
                        catch (Exception e) {
                            if (IQueryService.LOGGER.isErrorEnabled()) {
                                IQueryService.LOGGER.error((Object)("Query Service : Not supported a implementation of DataSource service. Fail to find a method from current preparedStatement [" + ps + "]"), (Throwable)e);
                            }
                            throw new SQLException("Query Service : Not supported a implementation of DataSource service. Fail to find a method from current preparedStatement [" + ps + "]");
                        }
                        int[] updateCountArray = new int[batchSize];
                        for (int i = 0; i < batchSize; ++i) {
                            int updateCount;
                            pss.setValues(ps, i);
                            updateCountArray[i] = updateCount = ps.executeUpdate();
                        }
                        int[] i = updateCountArray;
                        return i;
                    }
                    ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
                    InterruptibleBatchPreparedStatementSetter ipss = pss instanceof InterruptibleBatchPreparedStatementSetter ? (InterruptibleBatchPreparedStatementSetter)pss : null;
                    for (int i = 0; i < batchSize; ++i) {
                        pss.setValues(ps, i);
                        if (ipss != null && ipss.isBatchExhausted(i)) break;
                        rowsAffected.add(new Integer(ps.executeUpdate()));
                    }
                    int[] rowsAffectedArray = new int[rowsAffected.size()];
                    for (int i = 0; i < rowsAffectedArray.length; ++i) {
                        rowsAffectedArray[i] = (Integer)rowsAffected.get(i);
                    }
                    int[] nArray = rowsAffectedArray;
                    return nArray;
                }
                finally {
                    if (pss instanceof ParameterDisposer) {
                        ((ParameterDisposer)pss).cleanupParameters();
                    }
                }
            }
        });
    }
}

