/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc;

import anyframe.core.query.IRowCallbackHandler;
import anyframe.core.query.impl.LiveScrollPaginationVO;
import anyframe.core.query.impl.PaginationVO;
import anyframe.core.query.impl.jdbc.generator.IPagingSQLGenerator;
import anyframe.core.query.impl.jdbc.lob.AnyframeOracle8iLobHandler;
import anyframe.core.query.impl.jdbc.setter.PreparedStatementArgSetter;
import anyframe.core.query.impl.jdbc.setter.PreparedStatementArgTypeSetter;
import anyframe.core.query.impl.util.SQLTypeTransfer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.Assert;

public class PagingJdbcTemplate
extends JdbcTemplate {
    private IPagingSQLGenerator paginationSQLGetter;
    protected Integer maxFetchSize = null;

    public PagingJdbcTemplate() {
    }

    public PagingJdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }

    public void setPaginationSQLGetter(IPagingSQLGenerator paginationSQLGetter) {
        this.paginationSQLGetter = paginationSQLGetter;
    }

    public IPagingSQLGenerator getPaginationSQLGetter() {
        return this.paginationSQLGetter;
    }

    public Integer getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(Integer maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public List query(String sql, PreparedStatementSetter pss, RowMapper rowMapper, PaginationVO paginationVO) {
        if (pss == null) {
            return (List)this.query(new PagingPreparedStatementCreator(sql), new PagingRowMapperResultSetExtractor(rowMapper, paginationVO));
        }
        return (List)this.query(new PagingPreparedStatementCreator(sql), pss, new PagingRowMapperResultSetExtractor(rowMapper, paginationVO));
    }

    public List queryWithPagination(String sql, Object[] args, int[] argTypes, RowMapper rowMapper, PaginationVO paginationVO) throws Exception {
        if (this.paginationSQLGetter == null) {
            return this.query(sql, args, argTypes, rowMapper, paginationVO);
        }
        if (paginationVO.isCountRecordSize()) {
            long recordCount = this.executeCountSQL(sql, args, argTypes);
            paginationVO.setRecordCount(recordCount);
            paginationVO.setPageIndexToLast();
        }
        String paginationSql = this.getPaginationSQL(sql, args, argTypes, paginationVO);
        Object[] paginationArgs = this.getPaginationArgs();
        int[] paginationArgTypes = this.getPaginationArgTypes();
        return this.query(paginationSql, paginationArgs, paginationArgTypes, rowMapper);
    }

    public void queryWithPagination(String sql, Object[] args, int[] argTypes, RowCallbackHandler rch, PaginationVO paginationVO) throws Exception {
        if (this.paginationSQLGetter == null) {
            this.query(new PagingPreparedStatementCreator(sql), new PreparedStatementArgTypeSetter(args, argTypes, null), new PagingRowCallbackHandlerResultSetExtractor(rch, paginationVO));
            return;
        }
        if (paginationVO.isCountRecordSize()) {
            long recordCount = this.queryForLong(this.getCountSQL(sql), args, argTypes);
            paginationVO.setRecordCount(recordCount);
            paginationVO.setPageIndexToLast();
        }
        String paginationSql = this.getPaginationSQL(sql, args, argTypes, paginationVO);
        Object[] paginationArgs = this.getPaginationArgs();
        int[] paginationArgTypes = this.getPaginationArgTypes();
        this.query(paginationSql, paginationArgs, paginationArgTypes, rch);
    }

    public List queryWithPagination(String sql, RowMapper rowMapper, PaginationVO paginationVO) throws Exception {
        if (this.paginationSQLGetter == null) {
            return this.query(sql, null, null, rowMapper, paginationVO);
        }
        if (paginationVO.isCountRecordSize()) {
            long recordCount = this.executeCountSQL(sql, null, null);
            paginationVO.setRecordCount(recordCount);
            paginationVO.setPageIndexToLast();
        }
        String paginationSql = this.getPaginationSQL(sql, new Object[0], new int[0], paginationVO);
        Object[] paginationArgs = this.getPaginationArgs();
        return this.query(paginationSql, paginationArgs, rowMapper);
    }

    public List queryWithPagination(String sql, Object[] args, RowMapper rowMapper, PaginationVO paginationVO) throws Exception {
        if (this.paginationSQLGetter == null) {
            return this.query(sql, args, null, rowMapper, paginationVO);
        }
        if (paginationVO.isCountRecordSize()) {
            long recordCount = this.executeCountSQL(sql, args, null);
            paginationVO.setRecordCount(recordCount);
            paginationVO.setPageIndexToLast();
        }
        String paginationSql = this.getPaginationSQL(sql, args, new int[0], paginationVO);
        Object[] paginationArgs = this.getPaginationArgs();
        return this.query(paginationSql, paginationArgs, rowMapper);
    }

    public List queryForListWithPagination(String sql, Object[] args, int[] argTypes, PaginationVO paginationVO) throws Exception {
        return this.queryWithPagination(sql, args, argTypes, this.getColumnMapRowMapper(), paginationVO);
    }

    public int update(String sql, Object[] values, LobHandler lobHandler, String lobStatement, String[] lobTypes, Object[] lobKeys, Object[] lobValues) {
        int updateCount = this.update(sql, values);
        LinkedList<SqlParameter> lobParameters = null;
        lobParameters = new LinkedList<SqlParameter>();
        for (int i = 0; i < lobTypes.length; ++i) {
            int type = SQLTypeTransfer.getSQLType(lobTypes[i].toUpperCase());
            lobParameters.add(new SqlParameter(type));
        }
        PreparedStatementCreatorFactory preparedStatementFactory = new PreparedStatementCreatorFactory(lobStatement, lobParameters);
        this.query(preparedStatementFactory.newPreparedStatementCreator(lobKeys), new Oracle8iResultSetExtractor((AnyframeOracle8iLobHandler)lobHandler, lobValues));
        return updateCount;
    }

    public void query(String sql, Object[] args, int[] argTypes, RowCallbackHandler rch) {
        if (this.paginationSQLGetter == null) {
            this.query(new PagingPreparedStatementCreator(sql), new PreparedStatementArgTypeSetter(args, argTypes, null), new NonPagingRowCallbackHandlerResultSetExtractor(rch));
            return;
        }
        this.query(sql, new PreparedStatementArgTypeSetter(args, argTypes, null), new NonPagingRowCallbackHandlerResultSetExtractor(rch));
    }

    protected String getPaginationSQL(String originalSql, Object[] args, int[] argTypes, PaginationVO context) throws Exception {
        int pageIndex = context.getPageIndex();
        int pageSize = context.getPageSize();
        return this.paginationSQLGetter.getPaginationSQL(originalSql, args, argTypes, pageIndex, pageSize);
    }

    protected Object[] getPaginationArgs() {
        return this.paginationSQLGetter.getArgs();
    }

    protected int[] getPaginationArgTypes() {
        return this.paginationSQLGetter.getArgTypes();
    }

    public String getCountSQL(String originalSql) {
        return this.paginationSQLGetter.getCountSQL(originalSql);
    }

    private List query(String sql, Object[] args, int[] argTypes, RowMapper rowMapper, PaginationVO paginationVO) {
        if (args == null) {
            return (List)this.query(new PagingPreparedStatementCreator(sql), new PagingRowMapperResultSetExtractor(rowMapper, paginationVO));
        }
        if (argTypes == null) {
            return (List)this.query(new PagingPreparedStatementCreator(sql), new PreparedStatementArgSetter(args), new PagingRowMapperResultSetExtractor(rowMapper, paginationVO));
        }
        return (List)this.query(new PagingPreparedStatementCreator(sql), new PreparedStatementArgTypeSetter(args, argTypes, null), new PagingRowMapperResultSetExtractor(rowMapper, paginationVO));
    }

    public long executeCountSQL(String sql, Object[] args, int[] argTypes) {
        if (args == null) {
            return this.queryForLong(this.getCountSQL(sql));
        }
        if (argTypes == null) {
            return this.queryForLong(this.getCountSQL(sql), args);
        }
        return this.queryForLong(this.getCountSQL(sql), args, argTypes);
    }

    private class PagingRowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor {
        private final RowCallbackHandler rch;
        private PaginationVO paginationVO;

        public PagingRowCallbackHandlerResultSetExtractor(RowCallbackHandler rch, PaginationVO paginationVO) {
            this.rch = rch;
            this.paginationVO = paginationVO;
        }

        public Object extractData(ResultSet rs) throws SQLException {
            int pageIndex = this.paginationVO.getPageIndex();
            int pageSize = this.paginationVO.getPageSize();
            rs.last();
            this.paginationVO.setRecordCount(rs.getRow());
            if (this.paginationVO instanceof LiveScrollPaginationVO) {
                int targetIndex = ((LiveScrollPaginationVO)this.paginationVO).getStartIndex();
                if (targetIndex == 0) {
                    rs.beforeFirst();
                } else {
                    rs.absolute(targetIndex);
                }
            } else if (pageIndex == 1) {
                rs.beforeFirst();
            } else if (pageIndex > 1) {
                int pageCount = this.paginationVO.getPageCount();
                if (pageCount < pageIndex) {
                    rs.next();
                } else {
                    rs.absolute((pageIndex - 1) * pageSize);
                }
            }
            int rowNum = 0;
            if (rowNum == 0 && this.rch instanceof IRowCallbackHandler) {
                ((IRowCallbackHandler)this.rch).processMetaData(rs);
            }
            if (PagingJdbcTemplate.this.maxFetchSize == null) {
                while (rs.next() && rowNum < pageSize) {
                    this.rch.processRow(rs);
                    ++rowNum;
                }
            } else {
                while (rs.next() && rowNum < pageSize) {
                    if (rowNum > PagingJdbcTemplate.this.maxFetchSize) {
                        throw new DataRetrievalFailureException("Too many data in ResultSet maxFetchSize is " + PagingJdbcTemplate.this.maxFetchSize);
                    }
                    this.rch.processRow(rs);
                    ++rowNum;
                }
            }
            return null;
        }
    }

    private class NonPagingRowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor {
        private final RowCallbackHandler rch;

        public NonPagingRowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        public Object extractData(ResultSet rs) throws SQLException {
            int rowNum = 0;
            if (this.rch instanceof IRowCallbackHandler) {
                ((IRowCallbackHandler)this.rch).processMetaData(rs);
            }
            if (PagingJdbcTemplate.this.maxFetchSize == null) {
                while (rs.next()) {
                    this.rch.processRow(rs);
                    ++rowNum;
                }
            } else {
                while (rs.next()) {
                    if (rowNum > PagingJdbcTemplate.this.maxFetchSize) {
                        throw new DataRetrievalFailureException("Too many data in ResultSet. maxFetchSize is " + PagingJdbcTemplate.this.maxFetchSize);
                    }
                    this.rch.processRow(rs);
                    ++rowNum;
                }
            }
            return null;
        }
    }

    private class Oracle8iResultSetExtractor
    implements ResultSetExtractor {
        private AnyframeOracle8iLobHandler lobHandler;
        private Object[] lobValues;

        public Oracle8iResultSetExtractor(AnyframeOracle8iLobHandler lobHandler, Object[] lobValues) {
            this.lobHandler = lobHandler;
            this.lobValues = lobValues;
        }

        public Object extractData(ResultSet rs) throws SQLException {
            ResultSetMetaData meta = rs.getMetaData();
            while (rs.next()) {
                for (int i = 1; i < meta.getColumnCount() + 1; ++i) {
                    Object tObj = this.lobValues[i - 1];
                    if (tObj instanceof String) {
                        this.lobHandler.setClobOutputValue(rs, i, (String)tObj);
                        continue;
                    }
                    if (!(tObj instanceof byte[])) continue;
                    this.lobHandler.setBlobOutputValue(rs, i, (byte[])tObj);
                }
            }
            return null;
        }
    }

    class PagingRowMapperResultSetExtractor
    implements ResultSetExtractor {
        private final RowMapper rowMapper;
        private PaginationVO paginationVO;

        public PagingRowMapperResultSetExtractor(RowMapper rowMapper, PaginationVO paginationVO) {
            Assert.notNull((Object)rowMapper, (String)"Query Service : RowMapper is required");
            this.rowMapper = rowMapper;
            this.paginationVO = paginationVO;
        }

        public Object extractData(ResultSet rs) throws SQLException {
            int pageIndex = this.paginationVO.getPageIndex();
            int pageSize = this.paginationVO.getPageSize();
            rs.last();
            this.paginationVO.setRecordCount(rs.getRow());
            if (pageIndex == 1) {
                rs.beforeFirst();
            } else if (pageIndex > 1) {
                int pageCount = this.paginationVO.getPageCount();
                if (pageCount < pageIndex) {
                    rs.last();
                } else {
                    rs.absolute((pageIndex - 1) * pageSize);
                }
            }
            ArrayList<Object> results = new ArrayList<Object>();
            int rowNum = 0;
            if (PagingJdbcTemplate.this.maxFetchSize == null) {
                while (rs.next() && rowNum < pageSize) {
                    results.add(this.rowMapper.mapRow(rs, rowNum++));
                }
            } else {
                while (rs.next() && rowNum < pageSize) {
                    if (rowNum > PagingJdbcTemplate.this.maxFetchSize) {
                        throw new DataRetrievalFailureException("Too many data in ResultSet. maxFetchSize is " + PagingJdbcTemplate.this.maxFetchSize);
                    }
                    results.add(this.rowMapper.mapRow(rs, rowNum++));
                }
            }
            return results;
        }
    }

    private static class PagingPreparedStatementCreator
    implements PreparedStatementCreator {
        private final String sql;

        public PagingPreparedStatementCreator(String sql) {
            Assert.notNull((Object)sql, (String)"Query Service : SQL must not be null");
            this.sql = sql;
        }

        public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
            return conn.prepareStatement(this.sql, 1004, 1007);
        }
    }
}

