/*
 * Decompiled with CFR 0.152.
 */
package anyframe.core.query.impl.jdbc;

import anyframe.core.query.impl.LiveScrollPaginationVO;
import anyframe.core.query.impl.PaginationVO;
import anyframe.core.query.impl.jdbc.PagingJdbcTemplate;
import anyframe.core.query.impl.jdbc.setter.PreparedStatementArgTypeSetter;
import anyframe.core.query.impl.util.NamedParameterUtils;
import anyframe.core.query.impl.util.ParsedSql;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.jdbc.support.lob.LobHandler;

public class PagingNamedParamJdbcTemplate
extends NamedParameterJdbcTemplate {
    private PagingJdbcTemplate pagingJdbcTemplate = null;

    public List query(String sql, Map data, RowMapper rowMapper, PaginationVO paginationVO) throws Exception {
        MapSqlParameterSource mapSqlParameterSource = new MapSqlParameterSource(data);
        SqlParameterSetter sqlParameterSetter = this.setSqlParameter(sql, (SqlParameterSource)mapSqlParameterSource, data);
        return this.pagingJdbcTemplate.queryWithPagination(sqlParameterSetter.getSubstitutedSql(), sqlParameterSetter.getArgs(), sqlParameterSetter.getArgTypes(), rowMapper, paginationVO);
    }

    public PagingNamedParamJdbcTemplate(PagingJdbcTemplate jdbcTemplate, DataSource dataSource) {
        super(dataSource);
        this.pagingJdbcTemplate = jdbcTemplate;
    }

    public void setExceptionTranslator(SQLExceptionTranslator exceptionTranslator) {
        this.pagingJdbcTemplate.setExceptionTranslator(exceptionTranslator);
        ((JdbcTemplate)this.getJdbcOperations()).setExceptionTranslator(exceptionTranslator);
    }

    public void query(String sql, SqlParameterSource sqlParameterSource, RowCallbackHandler rch, PaginationVO paginationVO) throws Exception {
        SqlParameterSetter sqlParameterSetter = this.setSqlParameter(sql, sqlParameterSource);
        if (this.isPaging(paginationVO)) {
            this.pagingJdbcTemplate.queryWithPagination(sqlParameterSetter.getSubstitutedSql(), sqlParameterSetter.getArgs(), sqlParameterSetter.getArgTypes(), rch, paginationVO);
        } else {
            this.pagingJdbcTemplate.query(sqlParameterSetter.getSubstitutedSql(), sqlParameterSetter.getArgs(), sqlParameterSetter.getArgTypes(), rch);
        }
    }

    public int update(String sql, SqlParameterSource sqlParameterSource, LobHandler lobHandler) {
        SqlParameterSetter sqlParameterSetter = this.setSqlParameter(sql, sqlParameterSource);
        return this.getJdbcOperations().update(sqlParameterSetter.getSubstitutedSql(), (PreparedStatementSetter)new PreparedStatementArgTypeSetter(sqlParameterSetter.getArgs(), sqlParameterSetter.getArgTypes(), lobHandler));
    }

    protected boolean isPaging(PaginationVO paginationVO) {
        return paginationVO.getPageIndex() > 0 && paginationVO.getPageSize() > 0 || paginationVO instanceof LiveScrollPaginationVO;
    }

    private SqlParameterSetter setSqlParameter(String sql, SqlParameterSource sqlParameterSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        Object[] args = NamedParameterUtils.buildValueArray(parsedSql, sqlParameterSource);
        int[] argTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, sqlParameterSource);
        String substitutedSql = NamedParameterUtils.substituteNamedParameters(sql, sqlParameterSource);
        return new SqlParameterSetter(substitutedSql, args, argTypes);
    }

    private SqlParameterSetter setSqlParameter(String sql, SqlParameterSource sqlParameterSource, Map paramMap) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        Object[] args = NamedParameterUtils.buildValueArray(sql, paramMap);
        int[] argTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, sqlParameterSource);
        String substitutedSql = NamedParameterUtils.substituteNamedParameters(sql, sqlParameterSource);
        return new SqlParameterSetter(substitutedSql, args, argTypes);
    }

    private class SqlParameterSetter {
        private Object[] args;
        private int[] argTypes;
        private String substitutedSql;

        public SqlParameterSetter(String substitutedSql, Object[] args, int[] argTypes) {
            this.substitutedSql = substitutedSql;
            this.args = args;
            this.argTypes = argTypes;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public int[] getArgTypes() {
            return this.argTypes;
        }

        public String getSubstitutedSql() {
            return this.substitutedSql;
        }
    }
}

